/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util.io;

import java.io.IOException;
import org.jruby.nb.Ruby;
import org.jruby.nb.util.io.BadDescriptorException;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.PipeException;
import org.jruby.nb.util.io.Stream;

public class OpenFile {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int READWRITE = 3;
    public static final int APPEND = 64;
    public static final int CREATE = 128;
    public static final int BINMODE = 4;
    public static final int SYNC = 8;
    public static final int WBUF = 16;
    public static final int RBUF = 32;
    public static final int WSPLIT = 512;
    public static final int WSPLIT_INITIALIZED = 1024;
    public static final int SYNCWRITE = 10;
    private Stream mainStream;
    private Stream pipeStream;
    private int mode;
    private Process process;
    private int lineNumber = 0;
    private String path;
    private Finalizer finalizer;

    public Stream getMainStream() {
        return this.mainStream;
    }

    public void setMainStream(Stream mainStream) {
        this.mainStream = mainStream;
    }

    public Stream getPipeStream() {
        return this.pipeStream;
    }

    public void setPipeStream(Stream pipeStream) {
        this.pipeStream = pipeStream;
    }

    public Stream getWriteStream() {
        return this.pipeStream == null ? this.mainStream : this.pipeStream;
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString(Ruby runtime) {
        String modeString = OpenFile.getStringFromMode(this.mode);
        if (modeString == null) {
            throw runtime.newArgumentError("Illegal access modenum " + Integer.toOctalString(this.mode));
        }
        return modeString;
    }

    public static String getStringFromMode(int mode) {
        if ((mode & 0x40) != 0) {
            if ((mode & 3) != 0) {
                return "ab+";
            }
            return "ab";
        }
        switch (mode & 3) {
            case 1: {
                return "rb";
            }
            case 2: {
                return "wb";
            }
            case 3: {
                if ((mode & 0x80) != 0) {
                    return "wb+";
                }
                return "rb+";
            }
        }
        return null;
    }

    public void checkReadable(Ruby runtime) throws IOException, BadDescriptorException, PipeException, InvalidValueException {
        this.checkClosed(runtime);
        if ((this.mode & 1) == 0) {
            throw runtime.newIOError("not opened for reading");
        }
        if (!((this.mode & 0x10) == 0 && (this.mode & 0x2A) != 10 || this.mainStream.feof() || this.pipeStream != null)) {
            this.seek(0L, 1);
        }
    }

    public void seek(long offset, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushBeforeSeek();
        this.getWriteStream().lseek(offset, whence);
    }

    private void flushBeforeSeek() throws BadDescriptorException, IOException {
        if ((this.mode & 0x10) != 0) {
            this.fflush(this.getWriteStream());
        }
    }

    public void fflush(Stream stream) throws IOException, BadDescriptorException {
        int n;
        while ((n = stream.fflush()) == -1) {
        }
        this.mode &= 0xFFFFFFEF;
    }

    public void checkWritable(Ruby runtime) throws IOException, BadDescriptorException, InvalidValueException, PipeException {
        this.checkClosed(runtime);
        if ((this.mode & 2) == 0) {
            throw runtime.newIOError("not opened for writing");
        }
        if ((this.mode & 0x20) != 0 && !this.mainStream.feof() && this.pipeStream == null) {
            this.seek(0L, 1);
        }
        if (this.pipeStream == null) {
            this.mode &= 0xFFFFFFDF;
        }
    }

    public void checkClosed(Ruby runtime) {
        if (this.mainStream == null && this.pipeStream == null) {
            throw runtime.newIOError("closed stream");
        }
    }

    public boolean isOpen() {
        return this.mainStream != null || this.pipeStream != null;
    }

    public boolean isReadable() {
        return (this.mode & 1) != 0;
    }

    public boolean isWritable() {
        return (this.mode & 2) != 0;
    }

    public boolean isReadBuffered() {
        return (this.mode & 0x20) != 0;
    }

    public void setReadBuffered() {
        this.mode |= 0x20;
    }

    public boolean isWriteBuffered() {
        return (this.mode & 0x10) != 0;
    }

    public void setWriteBuffered() {
        this.mode |= 0x10;
    }

    public void setSync(boolean sync) {
        this.mode = sync ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
    }

    public boolean isSync() {
        return (this.mode & 8) != 0;
    }

    public boolean areBothEOF() throws IOException, BadDescriptorException {
        return this.mainStream.feof() && (this.pipeStream == null || this.pipeStream.feof());
    }

    public void setMode(int modes) {
        this.mode = modes;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void cleanup(Ruby runtime, boolean raise) {
        if (this.finalizer != null) {
            this.finalizer.finalize(runtime, raise);
        } else {
            this.finalize(runtime, raise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize(Ruby runtime, boolean raise) {
        block18: {
            try {
                ChannelDescriptor main = null;
                ChannelDescriptor pipe = null;
                if (this.pipeStream != null) {
                    pipe = this.pipeStream.getDescriptor();
                    try {
                        this.pipeStream.fflush();
                        this.pipeStream.fclose();
                    }
                    finally {
                        this.pipeStream = null;
                        runtime.getDescriptors().remove(pipe.getFileno());
                    }
                }
                if (this.mainStream == null) break block18;
                main = this.mainStream.getDescriptor();
                try {
                    if (pipe == null && this.isWriteBuffered()) {
                        this.mainStream.fflush();
                    }
                    this.mainStream.fclose();
                }
                catch (BadDescriptorException bde) {
                    if (main == pipe) {
                        break block18;
                    }
                    throw bde;
                }
                finally {
                    this.mainStream = null;
                    runtime.getDescriptors().remove(main.getFileno());
                }
            }
            catch (IOException ex) {
                if (raise) {
                    throw runtime.newIOErrorFromException(ex);
                }
            }
            catch (BadDescriptorException ex) {
                if (raise) {
                    throw runtime.newErrnoEBADFError();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static interface Finalizer {
        public void finalize(Ruby var1, boolean var2);
    }
}

