/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.scope;

import org.jruby.nb.RubyArray;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.scope.OneVarDynamicScope;

public class TwoVarDynamicScope
extends OneVarDynamicScope {
    protected IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 2) {
            throw new RuntimeException("TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    @Override
    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueOne == null) {
            this.variableValueOne = nil;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    @Override
    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset, value, depth - 1);
        }
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value;
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject setValueOneDepthZero(IRubyObject value) {
        this.variableValueOne = value;
        return this.variableValueOne;
    }

    @Override
    public void setArgValues(IRubyObject[] values, int size) {
        assert (size <= 2) : "TwoVarDynamicScope only supports scopes with two variables, not " + size;
        switch (size) {
            case 2: {
                this.variableValueOne = values[1];
            }
            case 1: {
                this.variableValueZero = values[0];
            }
        }
    }

    @Override
    public void setArgValues(IRubyObject arg0) {
        this.variableValueZero = arg0;
    }

    @Override
    public void setArgValues(IRubyObject arg0, IRubyObject arg1) {
        this.variableValueZero = arg0;
        this.variableValueOne = arg1;
    }

    @Override
    public void setArgValues(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        assert (false) : "TwoVarDynamicScope only supports two variables not three";
    }

    @Override
    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 2) : "TwoVarDynamicScope only supports scopes with two variables";
        if (this.staticScope.getRestArg() < 0) {
            switch (totalArgs) {
                case 0: {
                    return IRubyObject.NULL_ARRAY;
                }
                case 1: {
                    return new IRubyObject[]{this.variableValueZero};
                }
                case 2: {
                    return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
                }
            }
            throw new RuntimeException("more args requested than available variables");
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = RuntimeHelpers.splatValue(restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        switch (totalArgs) {
            case 2: {
                argValues[1] = this.variableValueOne;
            }
            case 1: {
                argValues[0] = this.variableValueZero;
            }
        }
        return argValues;
    }

    @Override
    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names = this.staticScope.getVariables();
        buf.append(names[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append(",");
        if (this.variableValueOne == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueOne);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

