/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.SharedScopeBlock;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ForNode
extends IterNode {
    public final CallSite callAdapter = MethodIndex.getCallSite("each");
    private Node iterNode;

    public ForNode(ISourcePosition position, Node varNode, Node bodyNode, Node iterNode) {
        super(position, varNode, null, bodyNode, NodeType.FORNODE);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Block block = SharedScopeBlock.newInterpretedSharedScopeClosure(context, this, context.getCurrentScope(), self);
        try {
            while (true) {
                try {
                    String savedFile = context.getFile();
                    int savedLine = context.getLine();
                    IRubyObject recv = null;
                    try {
                        recv = this.iterNode.interpret(runtime, context, self, aBlock);
                    }
                    finally {
                        context.setFile(savedFile);
                        context.setLine(savedLine);
                    }
                    return this.callAdapter.call(context, recv, block);
                }
                catch (JumpException.RetryJump rj) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }
}

