/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ruby.debugger.DebuggerAnnotation;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.model.CallSite;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public final class CallStackAnnotation {
    private static Map<CallSite, DebuggerAnnotation> stackAnnotations;
    private static CallSite[] callSites;
    private static RequestProcessor rp;
    private static RequestProcessor.Task taskRemove;
    private static RequestProcessor.Task taskAnnotate;

    private CallStackAnnotation() {
    }

    private static DebuggerAnnotation annotateCallSite(CallSite site) {
        Line line = EditorUtil.getLineAnnotable(site.getPath(), site.getLine());
        if (line == null) {
            return null;
        }
        DebuggerAnnotation annotation = new DebuggerAnnotation("CallSite", (Annotatable)line);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAnnotations() {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            if (taskRemove == null) {
                taskRemove = rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set ansToRemove = Collections.emptySet();
                        RequestProcessor requestProcessor = rp;
                        synchronized (requestProcessor) {
                            if (stackAnnotations != null) {
                                ansToRemove = new HashSet(stackAnnotations.values());
                                stackAnnotations.clear();
                                stackAnnotations = null;
                            }
                        }
                        CallStackAnnotation.detachAnnotations(ansToRemove);
                    }
                });
            }
        }
        taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void annotate(CallSite[] callSites) {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            if (taskRemove != null) {
                taskRemove.cancel();
            }
            CallStackAnnotation.callSites = callSites;
            if (taskAnnotate == null) {
                taskAnnotate = rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set annsToRemove = Collections.emptySet();
                        RequestProcessor requestProcessor = rp;
                        synchronized (requestProcessor) {
                            HashMap<CallSite, DebuggerAnnotation> newAnnotations = new HashMap<CallSite, DebuggerAnnotation>();
                            CallSite[] callSites = callSites;
                            if (stackAnnotations == null) {
                                stackAnnotations = new HashMap();
                            }
                            for (int i = 0; i < callSites.length; ++i) {
                                CallSite site = callSites[i];
                                if (newAnnotations.containsKey(site)) continue;
                                DebuggerAnnotation annotation = (DebuggerAnnotation)((Object)stackAnnotations.remove(site));
                                if (annotation == null) {
                                    annotation = CallStackAnnotation.annotateCallSite(site);
                                }
                                if (annotation == null) continue;
                                newAnnotations.put(site, annotation);
                            }
                            annsToRemove = new HashSet(stackAnnotations.values());
                            stackAnnotations = newAnnotations;
                        }
                        CallStackAnnotation.detachAnnotations(annsToRemove);
                    }
                });
            }
        }
        taskAnnotate.schedule(500);
    }

    private static void detachAnnotations(Collection<DebuggerAnnotation> annsToRemove) {
        for (DebuggerAnnotation ann : annsToRemove) {
            ann.detach();
        }
    }

    static {
        rp = new RequestProcessor("Ruby Debugger CallStack Annotation Refresher");
    }
}

