/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.lock;

import hidden.org.apache.jackrabbit.webdav.DavConstants;
import hidden.org.apache.jackrabbit.webdav.header.TimeoutHeader;
import hidden.org.apache.jackrabbit.webdav.lock.ActiveLock;
import hidden.org.apache.jackrabbit.webdav.lock.Scope;
import hidden.org.apache.jackrabbit.webdav.lock.Type;
import hidden.org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyName;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockDiscovery
extends AbstractDavProperty {
    private List activeLocks = new ArrayList();

    public LockDiscovery() {
        super(DavPropertyName.LOCKDISCOVERY, false);
    }

    public LockDiscovery(ActiveLock lock) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        this.addActiveLock(lock);
    }

    public LockDiscovery(ActiveLock[] locks) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        for (int i = 0; i < locks.length; ++i) {
            this.addActiveLock(locks[i]);
        }
    }

    private void addActiveLock(ActiveLock lock) {
        if (lock != null) {
            this.activeLocks.add(lock);
        }
    }

    public Object getValue() {
        return this.activeLocks;
    }

    public Element toXml(Document document) {
        Element lockdiscovery = this.getName().toXml(document);
        Iterator it = this.activeLocks.iterator();
        while (it.hasNext()) {
            ActiveLock lock = (ActiveLock)it.next();
            lockdiscovery.appendChild(lock.toXml(document));
        }
        return lockdiscovery;
    }

    public static LockDiscovery createFromXml(Element lockDiscoveryElement) {
        if (!DomUtil.matches(lockDiscoveryElement, "lockdiscovery", NAMESPACE)) {
            throw new IllegalArgumentException("DAV:lockdiscovery element expected.");
        }
        ArrayList<ALockImpl> activeLocks = new ArrayList<ALockImpl>();
        ElementIterator it = DomUtil.getChildren(lockDiscoveryElement, "activelock", NAMESPACE);
        while (it.hasNext()) {
            Element al = it.nextElement();
            activeLocks.add(new ALockImpl(al));
        }
        return new LockDiscovery(activeLocks.toArray(new ActiveLock[activeLocks.size()]));
    }

    private static class ALockImpl
    implements ActiveLock {
        private final Element alElement;

        private ALockImpl(Element alElement) {
            if (!DomUtil.matches(alElement, "activelock", DavConstants.NAMESPACE)) {
                throw new IllegalArgumentException("DAV:activelock element expected.");
            }
            this.alElement = alElement;
        }

        public boolean isLockedByToken(String lockToken) {
            String lt = this.getToken();
            if (lt == null) {
                return false;
            }
            return lt.equals(lockToken);
        }

        public boolean isExpired() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getToken() {
            Element ltEl = DomUtil.getChildElement(this.alElement, "locktoken", DavConstants.NAMESPACE);
            if (ltEl != null) {
                return DomUtil.getChildText(ltEl, "href", DavConstants.NAMESPACE);
            }
            return null;
        }

        public String getOwner() {
            String owner = null;
            Element ow = DomUtil.getChildElement(this.alElement, "owner", DavConstants.NAMESPACE);
            if (ow != null) {
                owner = DomUtil.hasChildElement(ow, "href", DavConstants.NAMESPACE) ? DomUtil.getChildTextTrim(ow, "href", DavConstants.NAMESPACE) : DomUtil.getTextTrim(ow);
            }
            return owner;
        }

        public void setOwner(String owner) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public long getTimeout() {
            String t = DomUtil.getChildTextTrim(this.alElement, "timeout", DavConstants.NAMESPACE);
            return TimeoutHeader.parse(t, Integer.MIN_VALUE);
        }

        public void setTimeout(long timeout) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isDeep() {
            String depth = DomUtil.getChildTextTrim(this.alElement, "depth", DavConstants.NAMESPACE);
            return "infinity".equalsIgnoreCase(depth);
        }

        public void setIsDeep(boolean isDeep) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Type getType() {
            return Type.createFromXml(DomUtil.getChildElement(this.alElement, "locktype", DavConstants.NAMESPACE));
        }

        public Scope getScope() {
            return Scope.createFromXml(DomUtil.getChildElement(this.alElement, "lockscope", DavConstants.NAMESPACE));
        }

        public Element toXml(Document document) {
            return (Element)document.importNode(this.alElement, true);
        }
    }
}

