/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.renderer.process.valign.BoxAlignContext;
import org.jfree.layouting.renderer.process.valign.InlineBlockAlignContext;
import org.jfree.layouting.renderer.process.valign.NodeAlignContext;
import org.jfree.layouting.renderer.process.valign.ReplacedContentAlignContext;
import org.jfree.layouting.renderer.process.valign.TextElementAlignContext;
import org.jfree.layouting.renderer.process.valign.VerticalAlignmentProcessor;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class InfiniteMajorAxisLayoutStep
extends IterateVisualProcessStep {
    private ParagraphBreakState breakState;
    private RenderBox continuedElement;

    public void compute(LogicalPageBox logicalPageBox) {
        this.breakState = null;
        this.continuedElement = null;
        this.startProcessing(logicalPageBox);
        this.breakState = null;
        this.continuedElement = null;
    }

    public void continueComputation(RenderBox renderBox) {
        if (renderBox.getContentAreaX2() == 0L || renderBox.getWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        this.breakState = null;
        this.continuedElement = renderBox;
        this.startProcessing(renderBox);
        this.continuedElement = null;
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        if (renderBox.isIgnorableForRendering()) {
            return false;
        }
        if (renderBox != this.continuedElement) {
            this.computeYPosition(renderBox);
        }
        if (this.breakState == null) {
            if (renderBox instanceof ParagraphRenderBox) {
                ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
                this.breakState = new ParagraphBreakState(paragraphRenderBox);
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    private void computeYPosition(RenderNode renderNode) {
        long l = renderNode.getEffectiveMarginTop();
        RenderBox renderBox = renderNode.getParent();
        if (renderBox instanceof TableRowRenderBox) {
            renderNode.setDirty(true);
            renderNode.setY(renderBox.getY());
        } else if (renderBox instanceof BlockRenderBox) {
            RenderNode renderNode2 = renderNode.getVisiblePrev();
            if (renderNode2 != null) {
                renderNode.setDirty(true);
                renderNode.setY(l + renderNode2.getY() + renderNode2.getHeight());
            } else {
                ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
                long l2 = computedLayoutProperties.getBorderTop() + computedLayoutProperties.getPaddingTop();
                renderNode.setDirty(true);
                renderNode.setY(l + l2 + renderBox.getY());
            }
        } else if (renderBox != null) {
            ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
            long l3 = computedLayoutProperties.getBorderTop() + computedLayoutProperties.getPaddingTop();
            renderNode.setDirty(true);
            renderNode.setY(l + l3 + renderBox.getY());
        } else {
            renderNode.setDirty(true);
            renderNode.setY(l);
        }
    }

    protected void finishBlockLevelBox(RenderBox renderBox) {
        long l;
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        RenderLength renderLength = computedLayoutProperties.getComputedWidth();
        RenderLength renderLength2 = renderBox.getBoxDefinition().getPreferredHeight();
        long l2 = renderLength2.resolve(renderLength.resolve(0L));
        ComputedLayoutProperties computedLayoutProperties2 = renderBox.getComputedLayoutProperties();
        long l3 = computedLayoutProperties2.getBorderBottom() + computedLayoutProperties2.getPaddingBottom();
        RenderNode renderNode = renderBox.getLastChild();
        if (renderNode != null) {
            l = renderNode.getY() + renderNode.getHeight() + renderNode.getEffectiveMarginBottom();
            long l4 = l - renderBox.getY() + l3;
            long l5 = Math.max(l4, l2);
            renderBox.setHeight(l5);
        } else {
            l = computedLayoutProperties2.getBorderTop() + computedLayoutProperties2.getBorderTop();
            renderBox.setHeight(Math.max(l2, l + l3));
        }
        if (this.breakState != null) {
            Object object = this.breakState.getSuspendItem();
            if (renderBox.getInstanceId() == object) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (object != null) {
                return;
            }
            if (renderBox instanceof ParagraphRenderBox) {
                ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
                paragraphRenderBox.setMajorLayoutAge(paragraphRenderBox.getLineboxContainer().getChangeTracker());
                this.breakState = null;
            }
        }
    }

    protected boolean startInlineLevelBox(RenderBox renderBox) {
        this.computeYPosition(renderBox);
        this.computeBaselineInfo(renderBox);
        if (this.breakState == null) {
            return true;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        if (renderBox instanceof InlineRenderBox) {
            this.breakState.openContext(new BoxAlignContext(renderBox));
            return true;
        }
        this.breakState.getCurrentLine().addChild(new InlineBlockAlignContext(renderBox));
        this.breakState.setSuspendItem(renderBox.getInstanceId());
        return false;
    }

    private void computeBaselineInfo(RenderBox renderBox) {
        for (RenderNode renderNode = renderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            if (!(renderNode instanceof RenderableText)) continue;
            RenderableText renderableText = (RenderableText)renderNode;
            renderBox.setBaselineInfo(renderableText.getBaselineInfo());
            break;
        }
        if (renderBox.getBaselineInfo() == null) {
            renderBox.setBaselineInfo(renderBox.getNominalBaselineInfo());
        }
    }

    protected void finishInlineLevelBox(RenderBox renderBox) {
        if (this.breakState == null) {
            return;
        }
        if (renderBox instanceof InlineRenderBox) {
            this.breakState.closeContext();
            return;
        }
        Object object = this.breakState.getSuspendItem();
        if (renderBox.getInstanceId() == object) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (object != null) {
            return;
        }
        if (renderBox instanceof ParagraphRenderBox) {
            throw new IllegalStateException("This cannot be.");
        }
    }

    protected void processInlineLevelNode(RenderNode renderNode) {
        this.computeYPosition(renderNode);
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        if (renderNode instanceof RenderableText) {
            this.breakState.getCurrentLine().addChild(new TextElementAlignContext((RenderableText)renderNode));
        } else if (renderNode instanceof RenderableReplacedContent) {
            this.breakState.getCurrentLine().addChild(new ReplacedContentAlignContext((RenderableReplacedContent)renderNode));
        } else if (renderNode instanceof SpacerRenderNode) {
            this.breakState.getCurrentLine().addChild(new NodeAlignContext(renderNode));
        } else {
            this.breakState.getCurrentLine().addChild(new NodeAlignContext(renderNode));
        }
    }

    protected void processBlockLevelNode(RenderNode renderNode) {
        this.computeYPosition(renderNode);
        if (renderNode instanceof FinishedRenderNode) {
            FinishedRenderNode finishedRenderNode = (FinishedRenderNode)renderNode;
            renderNode.setHeight(finishedRenderNode.getLayoutedHeight());
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        for (RenderNode renderNode = paragraphRenderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            if (!(renderNode instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + renderNode.getClass());
            }
            ParagraphPoolBox paragraphPoolBox = (ParagraphPoolBox)renderNode;
            this.startLine(paragraphPoolBox);
            this.processBoxChilds(paragraphPoolBox);
            this.finishLine(paragraphPoolBox);
        }
    }

    protected void startLine(ParagraphPoolBox paragraphPoolBox) {
        this.computeYPosition(paragraphPoolBox);
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.isSuspended()) {
            return;
        }
        this.breakState.openContext(new BoxAlignContext(paragraphPoolBox));
    }

    protected void finishLine(ParagraphPoolBox paragraphPoolBox) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        BoxAlignContext boxAlignContext = this.breakState.closeContext();
        VerticalAlignmentProcessor verticalAlignmentProcessor = new VerticalAlignmentProcessor();
        ComputedLayoutProperties computedLayoutProperties = paragraphPoolBox.getComputedLayoutProperties();
        long l = computedLayoutProperties.getBorderTop() + computedLayoutProperties.getPaddingTop();
        long l2 = paragraphPoolBox.getY() + l;
        RenderLength renderLength = paragraphPoolBox.getLineHeight();
        ComputedLayoutProperties computedLayoutProperties2 = paragraphPoolBox.getComputedLayoutProperties();
        RenderLength renderLength2 = computedLayoutProperties2.getBlockContextWidth();
        verticalAlignmentProcessor.align(boxAlignContext, l2, renderLength.resolve(renderLength2.resolve(0L)));
    }

    protected void finishOtherBox(RenderBox renderBox) {
        if (this.breakState != null) {
            Object object = this.breakState.getSuspendItem();
            if (renderBox.getInstanceId() == object) {
                this.breakState.setSuspendItem(null);
            }
        }
    }

    public static class ParagraphBreakState {
        private Object suspendItem;
        private FastStack contexts;
        private ParagraphRenderBox paragraph;

        public ParagraphBreakState(ParagraphRenderBox paragraphRenderBox) {
            if (paragraphRenderBox == null) {
                throw new NullPointerException();
            }
            this.paragraph = paragraphRenderBox;
            this.contexts = new FastStack();
        }

        public ParagraphRenderBox getParagraph() {
            return this.paragraph;
        }

        public Object getSuspendItem() {
            return this.suspendItem;
        }

        public void setSuspendItem(Object object) {
            this.suspendItem = object;
        }

        public boolean isSuspended() {
            return this.suspendItem != null;
        }

        public BoxAlignContext getCurrentLine() {
            if (this.contexts.isEmpty()) {
                return null;
            }
            return (BoxAlignContext)this.contexts.peek();
        }

        public void openContext(BoxAlignContext boxAlignContext) {
            if (!this.contexts.isEmpty()) {
                BoxAlignContext boxAlignContext2 = (BoxAlignContext)this.contexts.peek();
                boxAlignContext2.addChild(boxAlignContext);
            }
            this.contexts.push((Object)boxAlignContext);
        }

        public BoxAlignContext closeContext() {
            return (BoxAlignContext)this.contexts.pop();
        }
    }
}

