/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output;

import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.keys.font.FontFamilyValues;
import org.jfree.layouting.input.style.keys.font.FontSizeConstant;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.output.DefaultFontContext;
import org.jfree.layouting.output.OutputProcessorFeature;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public abstract class AbstractOutputProcessorMetaData
implements OutputProcessorMetaData {
    private HashSet features;
    private HashMap fontSizes;
    private HashMap numericFeatures;
    private HashMap fontFamilies;
    private FontStorage fontStorage;
    private static final Class[] SUPPORTED_TYPES = new Class[]{DrawableWrapper.class, Image.class};

    protected AbstractOutputProcessorMetaData(FontStorage fontStorage) {
        if (fontStorage == null) {
            throw new NullPointerException();
        }
        this.fontStorage = fontStorage;
        this.features = new HashSet();
        this.numericFeatures = new HashMap();
        ExtendedConfiguration extendedConfiguration = LibLayoutBoot.getInstance().getExtendedConfig();
        double d = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSize", 12);
        int n = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.xx-small", 60);
        int n2 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.x-small", 75);
        int n3 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.small", 89);
        int n4 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.medium", 100);
        int n5 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.large", 120);
        int n6 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.x-large", 150);
        int n7 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSizeFactor.xx-large", 200);
        this.fontSizes = new HashMap();
        this.fontSizes.put(FontSizeConstant.XX_SMALL, new Double(d * (double)n / 100.0));
        this.fontSizes.put(FontSizeConstant.X_SMALL, new Double(d * (double)n2 / 100.0));
        this.fontSizes.put(FontSizeConstant.SMALL, new Double(d * (double)n3 / 100.0));
        this.fontSizes.put(FontSizeConstant.MEDIUM, new Double(d * (double)n4 / 100.0));
        this.fontSizes.put(FontSizeConstant.LARGE, new Double(d * (double)n5 / 100.0));
        this.fontSizes.put(FontSizeConstant.X_LARGE, new Double(d * (double)n6 / 100.0));
        this.fontSizes.put(FontSizeConstant.XX_LARGE, new Double(d * (double)n7 / 100.0));
        this.fontFamilies = new HashMap();
        this.setNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE, d);
        double d2 = extendedConfiguration.getIntProperty("org.jfree.layouting.defaults.FontSmoothThreshold", 8);
        this.setNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD, d2);
    }

    protected void setFamilyMapping(CSSConstant cSSConstant, String string) {
        if (cSSConstant == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fontFamilies.put(cSSConstant, string);
    }

    public double getFontSize(CSSConstant cSSConstant) {
        Double d = (Double)this.fontSizes.get(cSSConstant);
        if (d == null) {
            return this.getNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE);
        }
        return d;
    }

    protected void addFeature(OutputProcessorFeature.BooleanOutputProcessorFeature booleanOutputProcessorFeature) {
        if (booleanOutputProcessorFeature == null) {
            throw new NullPointerException();
        }
        this.features.add(booleanOutputProcessorFeature);
    }

    public boolean isFeatureSupported(OutputProcessorFeature.BooleanOutputProcessorFeature booleanOutputProcessorFeature) {
        if (booleanOutputProcessorFeature == null) {
            throw new NullPointerException();
        }
        return this.features.contains(booleanOutputProcessorFeature);
    }

    protected void setNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature numericOutputProcessorFeature, double d) {
        if (numericOutputProcessorFeature == null) {
            throw new NullPointerException();
        }
        this.numericFeatures.put(numericOutputProcessorFeature, new Double(d));
    }

    public double getNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature numericOutputProcessorFeature) {
        if (numericOutputProcessorFeature == null) {
            throw new NullPointerException();
        }
        Double d = (Double)this.numericFeatures.get(numericOutputProcessorFeature);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public FontStorage getFontStorage() {
        return this.fontStorage;
    }

    public String getNormalizedFontFamilyName(String string) {
        String string2 = (String)this.fontFamilies.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public FontFamily getFontFamilyForGenericName(CSSConstant cSSConstant) {
        if (FontFamilyValues.NONE.equals(cSSConstant)) {
            return null;
        }
        String string = (String)this.fontFamilies.get(cSSConstant);
        if (string == null) {
            return this.getDefaultFontFamily();
        }
        FontFamily fontFamily = this.fontStorage.getFontRegistry().getFontFamily(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        return this.getDefaultFontFamily();
    }

    protected FontRegistry getFontRegistry() {
        return this.fontStorage.getFontRegistry();
    }

    public PageSize getDefaultPageSize() {
        return PageSize.A4;
    }

    public int getVerticalPageSpan() {
        return 1;
    }

    public int getHorizontalPageSpan() {
        return 1;
    }

    public String getMediaType() {
        return "print";
    }

    public boolean isValid(FontSpecification fontSpecification) {
        FontRegistry fontRegistry = this.getFontRegistry();
        String string = fontSpecification.getFontFamily();
        if (string == null) {
            return false;
        }
        FontFamily fontFamily = fontRegistry.getFontFamily(string);
        return fontFamily != null;
    }

    public FontMetrics getFontMetrics(FontSpecification fontSpecification) {
        String string = fontSpecification.getFontFamily();
        if (string == null) {
            DebugLog.log((Object)"No font family specified.");
            return null;
        }
        FontRegistry fontRegistry = this.getFontRegistry();
        FontFamily fontFamily = fontRegistry.getFontFamily(string);
        if (fontFamily == null) {
            DebugLog.log((Object)"Unable to lookup the font family.");
            return null;
        }
        DefaultFontContext defaultFontContext = new DefaultFontContext(this, fontSpecification.isAntiAliasing(), fontSpecification.getFontSize(), "UTF-8", false);
        FontRecord fontRecord = fontFamily.getFontRecord(fontSpecification.getFontWeight() > 600, fontSpecification.isItalic() || fontSpecification.isOblique());
        FontMetrics fontMetrics = this.getFontStorage().getFontMetrics(fontRecord.getIdentifier(), (FontContext)defaultFontContext);
        if (fontMetrics == null) {
            throw new NullPointerException("FontMetrics returned from factory is null.");
        }
        return fontMetrics;
    }

    public Class[] getSupportedResourceTypes() {
        return (Class[])SUPPORTED_TYPES.clone();
    }
}

