/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class ParagraphConverter
implements Converter {
    public ConverterAttributeSet convertToCSS(Object object, Object object2, ConverterAttributeSet converterAttributeSet, Element element) {
        if (object instanceof StyleConstants.ParagraphConstants) {
            StyleConstants.ParagraphConstants paragraphConstants = (StyleConstants.ParagraphConstants)object;
            return this.handleParagraphConstants(paragraphConstants, object2);
        }
        return null;
    }

    private ConverterAttributeSet handleParagraphConstants(StyleConstants.ParagraphConstants paragraphConstants, Object object) {
        ConverterAttributeSet converterAttributeSet = new ConverterAttributeSet();
        if (paragraphConstants == StyleConstants.FirstLineIndent) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(TextStyleKeys.TEXT_INDENT.getName(), cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.RightIndent) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(BoxStyleKeys.MARGIN_RIGHT.getName(), cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.LeftIndent) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(BoxStyleKeys.MARGIN_LEFT.getName(), cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.LineSpacing) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.EM, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(LineStyleKeys.LINE_HEIGHT, cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.SpaceAbove) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(BoxStyleKeys.MARGIN_TOP.getName(), cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.SpaceBelow) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue(CSSNumericType.PT, Double.parseDouble(object.toString()));
            converterAttributeSet.addAttribute(BoxStyleKeys.MARGIN_BOTTOM.getName(), cSSNumericValue);
        } else if (paragraphConstants == StyleConstants.Alignment) {
            CSSConstant cSSConstant = null;
            int n = Integer.parseInt(object.toString());
            if (n == 1) {
                cSSConstant = TextAlign.CENTER;
            } else if (n == 3) {
                cSSConstant = TextAlign.JUSTIFY;
            } else if (n == 0) {
                cSSConstant = TextAlign.LEFT;
            } else if (n == 2) {
                cSSConstant = TextAlign.RIGHT;
            }
            converterAttributeSet.addAttribute(TextStyleKeys.TEXT_ALIGN.getName(), cSSConstant);
        } else {
            DebugLog.log((Object)("Unkown type of paragraphe attribute: " + paragraphConstants));
            return null;
        }
        return converterAttributeSet;
    }
}

