/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Iterator;
import sun.java2d.pisces.Helpers;

class Curve {
    float ax;
    float ay;
    float bx;
    float by;
    float cx;
    float cy;
    float dx;
    float dy;
    float dax;
    float day;
    float dbx;
    float dby;

    Curve() {
    }

    void set(float[] fArray, int n) {
        switch (n) {
            case 8: {
                this.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                break;
            }
            case 6: {
                this.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                break;
            }
            default: {
                throw new InternalError("Curves can only be cubic or quadratic");
            }
        }
    }

    void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.ax = 3.0f * (f3 - f5) + f7 - f;
        this.ay = 3.0f * (f4 - f6) + f8 - f2;
        this.bx = 3.0f * (f - 2.0f * f3 + f5);
        this.by = 3.0f * (f2 - 2.0f * f4 + f6);
        this.cx = 3.0f * (f3 - f);
        this.cy = 3.0f * (f4 - f2);
        this.dx = f;
        this.dy = f2;
        this.dax = 3.0f * this.ax;
        this.day = 3.0f * this.ay;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ay = 0.0f;
        this.ax = 0.0f;
        this.bx = f - 2.0f * f3 + f5;
        this.by = f2 - 2.0f * f4 + f6;
        this.cx = 2.0f * (f3 - f);
        this.cy = 2.0f * (f4 - f2);
        this.dx = f;
        this.dy = f2;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    float xat(float f) {
        return f * (f * (f * this.ax + this.bx) + this.cx) + this.dx;
    }

    float yat(float f) {
        return f * (f * (f * this.ay + this.by) + this.cy) + this.dy;
    }

    float dxat(float f) {
        return f * (f * this.dax + this.dbx) + this.cx;
    }

    float dyat(float f) {
        return f * (f * this.day + this.dby) + this.cy;
    }

    private float ddxat(float f) {
        return 2.0f * this.dax * f + this.dbx;
    }

    private float ddyat(float f) {
        return 2.0f * this.day * f + this.dby;
    }

    int dxRoots(float[] fArray, int n) {
        return Helpers.quadraticRoots(this.dax, this.dbx, this.cx, fArray, n);
    }

    int dyRoots(float[] fArray, int n) {
        return Helpers.quadraticRoots(this.day, this.dby, this.cy, fArray, n);
    }

    int infPoints(float[] fArray, int n) {
        float f = this.dax * this.dby - this.dbx * this.day;
        float f2 = 2.0f * (this.cy * this.dax - this.day * this.cx);
        float f3 = this.cy * this.dbx - this.cx * this.dby;
        return Helpers.quadraticRoots(f, f2, f3, fArray, n);
    }

    private int perpendiculardfddf(float[] fArray, int n, float f) {
        assert (fArray.length >= n + 4);
        float f2 = 2.0f * (this.dax * this.dax + this.day * this.day);
        float f3 = 3.0f * (this.dax * this.dbx + this.day * this.dby);
        float f4 = 2.0f * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        float f5 = this.dbx * this.cx + this.dby * this.cy;
        return Helpers.cubicRootsInAB(f2, f3, f4, f5, fArray, n, f, 0.0f, 1.0f);
    }

    int rootsOfROCMinusW(float[] fArray, int n, float f, float f2) {
        assert (n <= 6 && fArray.length >= 10);
        int n2 = n;
        int n3 = this.perpendiculardfddf(fArray, n, f2);
        float f3 = 0.0f;
        float f4 = this.ROCsq(f3) - f * f;
        fArray[n + n3] = 1.0f;
        ++n3;
        for (int i = n; i < n + n3; ++i) {
            float f5 = fArray[i];
            float f6 = this.ROCsq(f5) - f * f;
            if (f4 == 0.0f) {
                fArray[n2++] = f3;
            } else if (f6 * f4 < 0.0f) {
                fArray[n2++] = this.falsePositionROCsqMinusX(f3, f5, f * f, f2);
            }
            f3 = f5;
            f4 = f6;
        }
        return n2 - n;
    }

    private static float eliminateInf(float f) {
        return f == Float.POSITIVE_INFINITY ? Float.MAX_VALUE : (f == Float.NEGATIVE_INFINITY ? Float.MIN_VALUE : f);
    }

    private float falsePositionROCsqMinusX(float f, float f2, float f3, float f4) {
        int n = 0;
        float f5 = f2;
        float f6 = Curve.eliminateInf(this.ROCsq(f5) - f3);
        float f7 = f;
        float f8 = Curve.eliminateInf(this.ROCsq(f7) - f3);
        float f9 = f7;
        for (int i = 0; i < 100 && Math.abs(f5 - f7) > f4 * Math.abs(f5 + f7); ++i) {
            f9 = (f8 * f5 - f6 * f7) / (f8 - f6);
            float f10 = this.ROCsq(f9) - f3;
            if (f10 * f6 > 0.0f) {
                f6 = f10;
                f5 = f9;
                if (n < 0) {
                    f8 /= (float)(1 << -n);
                    --n;
                    continue;
                }
                n = -1;
                continue;
            }
            if (!(f10 * f8 > 0.0f)) break;
            f8 = f10;
            f7 = f9;
            if (n > 0) {
                f6 /= (float)(1 << n);
                ++n;
                continue;
            }
            n = 1;
        }
        return f9;
    }

    private float ROCsq(float f) {
        float f2 = this.dxat(f);
        float f3 = this.dyat(f);
        float f4 = this.ddxat(f);
        float f5 = this.ddyat(f);
        float f6 = f2 * f2 + f3 * f3;
        float f7 = f4 * f4 + f5 * f5;
        float f8 = f4 * f2 + f5 * f3;
        float f9 = f6 * f6 / (f6 * f7 - f8 * f8) * f6;
        return f9;
    }

    static Iterator<float[]> breakPtsAtTs(final float[][] fArray, final int n, final float[] fArray2, final int n2) {
        assert (fArray.length >= 2 && fArray[0].length >= 8 && n2 <= fArray2.length);
        return new Iterator<float[]>(){
            int nextIdx = 0;
            int nextCurveIdx = 0;
            float prevT = 0.0f;

            @Override
            public boolean hasNext() {
                return this.nextCurveIdx < n2 + 1;
            }

            @Override
            public float[] next() {
                float[] fArray3;
                if (this.nextCurveIdx < n2) {
                    float f = fArray2[this.nextCurveIdx];
                    float f2 = (f - this.prevT) / (1.0f - this.prevT);
                    Helpers.subdivideAt(f2, fArray[this.nextIdx], 0, fArray[this.nextIdx], 0, fArray[1 - this.nextIdx], 0, n);
                    Curve.updateTs(fArray2, fArray2[this.nextCurveIdx], this.nextCurveIdx + 1, n2 - this.nextCurveIdx - 1);
                    fArray3 = fArray[this.nextIdx];
                    this.nextIdx = 1 - this.nextIdx;
                } else {
                    fArray3 = fArray[this.nextIdx];
                }
                ++this.nextCurveIdx;
                return fArray3;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static void updateTs(float[] fArray, float f, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            fArray[i] = (fArray[i] - f) / (1.0f - f);
        }
    }
}

