/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.util;

import java.dyn.MethodType;
import sun.dyn.empty.Empty;
import sun.dyn.util.Wrapper;

public class VerifyType {
    private static final Class<?> NULL_CLASS;

    private VerifyType() {
    }

    public static boolean isNullConversion(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz2.isInterface()) {
            clazz2 = Object.class;
        }
        if (clazz.isInterface()) {
            clazz = Object.class;
        }
        if (clazz == clazz2) {
            return true;
        }
        if (clazz2 == Void.TYPE) {
            return true;
        }
        if (VerifyType.isNullType(clazz)) {
            return !clazz2.isPrimitive();
        }
        if (!clazz.isPrimitive()) {
            return clazz2.isAssignableFrom(clazz);
        }
        if (clazz2 == Integer.TYPE) {
            return Wrapper.forPrimitiveType(clazz).isSubwordOrInt();
        }
        return false;
    }

    public static boolean isNullReferenceConversion(Class<?> clazz, Class<?> clazz2) {
        assert (!clazz2.isPrimitive());
        if (clazz2.isInterface()) {
            return true;
        }
        if (VerifyType.isNullType(clazz)) {
            return true;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean isNullType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz == NULL_CLASS || clazz == Empty.class;
    }

    public static boolean isNullConversion(MethodType methodType, MethodType methodType2) {
        if (methodType == methodType2) {
            return true;
        }
        int n = methodType.parameterCount();
        if (n != methodType2.parameterCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (VerifyType.isNullConversion(methodType.parameterType(i), methodType2.parameterType(i))) continue;
            return false;
        }
        return VerifyType.isNullConversion(methodType2.returnType(), methodType.returnType());
    }

    public static int canPassUnchecked(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2) {
            return 1;
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                return 1;
            }
            if (clazz == Void.TYPE) {
                return 0;
            }
            if (!clazz.isPrimitive()) {
                return 0;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            Wrapper wrapper2 = Wrapper.forPrimitiveType(clazz2);
            if (wrapper.isSubwordOrInt() && wrapper2.isSubwordOrInt()) {
                if (wrapper.bitWidth() >= wrapper2.bitWidth()) {
                    return -1;
                }
                if (!wrapper2.isSigned() && wrapper.isSigned()) {
                    return -1;
                }
            }
            if (clazz == Float.TYPE || clazz2 == Float.TYPE) {
                if (clazz == Double.TYPE || clazz2 == Double.TYPE) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
        if (clazz.isPrimitive()) {
            return 0;
        }
        if (VerifyType.isNullReferenceConversion(clazz, clazz2)) {
            return 1;
        }
        return -1;
    }

    public static int canPassRaw(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                return 1;
            }
            if (clazz == Void.TYPE) {
                return clazz2 == Integer.TYPE ? 1 : 0;
            }
            if (VerifyType.isNullType(clazz)) {
                return 1;
            }
            if (!clazz.isPrimitive()) {
                return 0;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            Wrapper wrapper2 = Wrapper.forPrimitiveType(clazz2);
            if (wrapper.stackSlots() == wrapper2.stackSlots()) {
                return 1;
            }
            if (wrapper.isSubwordOrInt() && wrapper2 == Wrapper.VOID) {
                return 1;
            }
            return 0;
        }
        if (clazz.isPrimitive()) {
            return 0;
        }
        if (VerifyType.isNullReferenceConversion(clazz, clazz2)) {
            return 1;
        }
        return -1;
    }

    public static boolean isSpreadArgType(Class<?> clazz) {
        return clazz.isArray();
    }

    public static Class<?> spreadArgElementType(Class<?> clazz, int n) {
        return clazz.getComponentType();
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Null");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        NULL_CLASS = clazz;
    }
}

