/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private int flag;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed = false;
    private boolean entryEOF = false;
    private ZipCoder zc;
    private byte[] b = new byte[256];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipInputStream(InputStream inputStream) {
        this(inputStream, Charset.forName("UTF-8"));
    }

    public ZipInputStream(InputStream inputStream, Charset charset) {
        super(new PushbackInputStream(inputStream, 512), new Inflater(true), 512);
        this.usesDefaultInflater = true;
        if (inputStream == null) {
            throw new NullPointerException("in is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.inf.reset();
        this.entry = this.readLOC();
        if (this.entry == null) {
            return null;
        }
        if (this.entry.method == 0) {
            this.remaining = this.entry.size;
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.method) {
            case 8: {
                n2 = super.read(byArray, n, n2);
                if (n2 == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(byArray, n, n2);
                }
                return n2;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)n2 > this.remaining) {
                    n2 = (int)this.remaining;
                }
                if ((n2 = this.in.read(byArray, n, n2)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(byArray, n, n2);
                this.remaining -= (long)n2;
                if (this.remaining == 0L && this.entry.crc != this.crc.getValue()) {
                    throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(this.entry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                return n2;
            }
        }
        throw new ZipException("invalid compression method");
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > this.tmpbuf.length) {
                n2 = this.tmpbuf.length;
            }
            if ((n2 = this.read(this.tmpbuf, 0, n2)) != -1) continue;
            this.entryEOF = true;
            break;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        int n;
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        this.flag = ZipInputStream.get16(this.tmpbuf, 6);
        int n2 = ZipInputStream.get16(this.tmpbuf, 26);
        if (n2 > (n = this.b.length)) {
            while (n2 > (n *= 2)) {
            }
            this.b = new byte[n];
        }
        this.readFully(this.b, 0, n2);
        ZipEntry zipEntry = this.createZipEntry((this.flag & 0x800) != 0 ? this.zc.toStringUTF8(this.b, n2) : this.zc.toString(this.b, n2));
        if ((this.flag & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        zipEntry.method = ZipInputStream.get16(this.tmpbuf, 8);
        zipEntry.time = ZipInputStream.get32(this.tmpbuf, 10);
        if ((this.flag & 8) == 8) {
            if (zipEntry.method != 8) {
                throw new ZipException("only DEFLATED entries can have EXT descriptor");
            }
        } else {
            zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 14);
            zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 18);
            zipEntry.size = ZipInputStream.get32(this.tmpbuf, 22);
        }
        if ((n2 = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] byArray = new byte[n2];
            this.readFully(byArray, 0, n2);
            zipEntry.setExtra(byArray);
            if (zipEntry.csize == 0xFFFFFFFFL || zipEntry.size == 0xFFFFFFFFL) {
                int n3 = 0;
                while (n3 + 4 < n2) {
                    int n4 = ZipInputStream.get16(byArray, n3 + 2);
                    if (ZipInputStream.get16(byArray, n3) == 1) {
                        if (n4 < 16 || (n3 += 4) + n4 > n2) {
                            return zipEntry;
                        }
                        zipEntry.size = ZipInputStream.get64(byArray, n3);
                        zipEntry.csize = ZipInputStream.get64(byArray, n3 + 8);
                        break;
                    }
                    n3 += n4 + 4;
                }
            }
        }
        return zipEntry;
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    private void readEnd(ZipEntry zipEntry) throws IOException {
        int n = this.inf.getRemaining();
        if (n > 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
        }
        if ((this.flag & 8) == 8) {
            if (this.inf.getBytesWritten() > 0xFFFFFFFFL || this.inf.getBytesRead() > 0xFFFFFFFFL) {
                this.readFully(this.tmpbuf, 0, 24);
                long l = ZipInputStream.get32(this.tmpbuf, 0);
                if (l != 134695760L) {
                    zipEntry.crc = l;
                    zipEntry.csize = ZipInputStream.get64(this.tmpbuf, 4);
                    zipEntry.size = ZipInputStream.get64(this.tmpbuf, 12);
                    ((PushbackInputStream)this.in).unread(this.tmpbuf, 19, 4);
                } else {
                    zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 4);
                    zipEntry.csize = ZipInputStream.get64(this.tmpbuf, 8);
                    zipEntry.size = ZipInputStream.get64(this.tmpbuf, 16);
                }
            } else {
                this.readFully(this.tmpbuf, 0, 16);
                long l = ZipInputStream.get32(this.tmpbuf, 0);
                if (l != 134695760L) {
                    zipEntry.crc = l;
                    zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 4);
                    zipEntry.size = ZipInputStream.get32(this.tmpbuf, 8);
                    ((PushbackInputStream)this.in).unread(this.tmpbuf, 11, 4);
                } else {
                    zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 4);
                    zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 8);
                    zipEntry.size = ZipInputStream.get32(this.tmpbuf, 12);
                }
            }
        }
        if (zipEntry.size != this.inf.getBytesWritten()) {
            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.inf.getBytesWritten() + " bytes)");
        }
        if (zipEntry.csize != this.inf.getBytesRead()) {
            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.inf.getBytesRead() + " bytes)");
        }
        if (zipEntry.crc != this.crc.getValue()) {
            throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
        }
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return ((long)ZipInputStream.get16(byArray, n) | (long)ZipInputStream.get16(byArray, n + 2) << 16) & 0xFFFFFFFFL;
    }

    private static final long get64(byte[] byArray, int n) {
        return ZipInputStream.get32(byArray, n) | ZipInputStream.get32(byArray, n + 4) << 32;
    }
}

