/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.attribute;

import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class AclEntry {
    private final AclEntryType type;
    private final UserPrincipal who;
    private final Set<AclEntryPermission> perms;
    private final Set<AclEntryFlag> flags;
    private volatile int hash;

    private AclEntry(AclEntryType aclEntryType, UserPrincipal userPrincipal, Set<AclEntryPermission> set, Set<AclEntryFlag> set2) {
        this.type = aclEntryType;
        this.who = userPrincipal;
        this.perms = set;
        this.flags = set2;
    }

    public static Builder newBuilder() {
        Set set = Collections.emptySet();
        Set set2 = Collections.emptySet();
        return new Builder(null, null, set, set2);
    }

    public static Builder newBuilder(AclEntry aclEntry) {
        return new Builder(aclEntry.type, aclEntry.who, aclEntry.perms, aclEntry.flags);
    }

    public AclEntryType type() {
        return this.type;
    }

    public UserPrincipal principal() {
        return this.who;
    }

    public Set<AclEntryPermission> permissions() {
        return new HashSet<AclEntryPermission>(this.perms);
    }

    public Set<AclEntryFlag> flags() {
        return new HashSet<AclEntryFlag>(this.flags);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof AclEntry)) {
            return false;
        }
        AclEntry aclEntry = (AclEntry)object;
        if (this.type != aclEntry.type) {
            return false;
        }
        if (!this.who.equals(aclEntry.who)) {
            return false;
        }
        if (!this.perms.equals(aclEntry.perms)) {
            return false;
        }
        return this.flags.equals(aclEntry.flags);
    }

    private static int hash(int n, Object object) {
        return n * 127 + object.hashCode();
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = this.type.hashCode();
        n = AclEntry.hash(n, this.who);
        n = AclEntry.hash(n, this.perms);
        this.hash = n = AclEntry.hash(n, this.flags);
        return this.hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.who.getName());
        stringBuilder.append(':');
        for (AclEntryPermission enum_ : this.perms) {
            stringBuilder.append(enum_.name());
            stringBuilder.append('/');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append(':');
        if (!this.flags.isEmpty()) {
            for (AclEntryFlag aclEntryFlag : this.flags) {
                stringBuilder.append(aclEntryFlag.name());
                stringBuilder.append('/');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append(':');
        }
        stringBuilder.append(this.type.name());
        return stringBuilder.toString();
    }

    public static final class Builder {
        private AclEntryType type;
        private UserPrincipal who;
        private Set<AclEntryPermission> perms;
        private Set<AclEntryFlag> flags;

        private Builder(AclEntryType aclEntryType, UserPrincipal userPrincipal, Set<AclEntryPermission> set, Set<AclEntryFlag> set2) {
            assert (set != null && set2 != null);
            this.type = aclEntryType;
            this.who = userPrincipal;
            this.perms = set;
            this.flags = set2;
        }

        public AclEntry build() {
            if (this.type == null) {
                throw new IllegalStateException("Missing type component");
            }
            if (this.who == null) {
                throw new IllegalStateException("Missing who component");
            }
            return new AclEntry(this.type, this.who, this.perms, this.flags);
        }

        public Builder setType(AclEntryType aclEntryType) {
            if (aclEntryType == null) {
                throw new NullPointerException();
            }
            this.type = aclEntryType;
            return this;
        }

        public Builder setPrincipal(UserPrincipal userPrincipal) {
            if (userPrincipal == null) {
                throw new NullPointerException();
            }
            this.who = userPrincipal;
            return this;
        }

        private static void checkSet(Set<?> set, Class<?> clazz) {
            for (Object obj : set) {
                if (obj == null) {
                    throw new NullPointerException();
                }
                clazz.cast(obj);
            }
        }

        public Builder setPermissions(Set<AclEntryPermission> set) {
            set = new HashSet<AclEntryPermission>(set);
            Builder.checkSet(set, AclEntryPermission.class);
            this.perms = set;
            return this;
        }

        public Builder setPermissions(AclEntryPermission ... aclEntryPermissionArray) {
            HashSet<AclEntryPermission> hashSet = new HashSet<AclEntryPermission>(aclEntryPermissionArray.length);
            for (AclEntryPermission aclEntryPermission : aclEntryPermissionArray) {
                if (aclEntryPermission == null) {
                    throw new NullPointerException();
                }
                hashSet.add(aclEntryPermission);
            }
            this.perms = hashSet;
            return this;
        }

        public Builder setFlags(Set<AclEntryFlag> set) {
            set = new HashSet<AclEntryFlag>(set);
            Builder.checkSet(set, AclEntryFlag.class);
            this.flags = set;
            return this;
        }

        public Builder setFlags(AclEntryFlag ... aclEntryFlagArray) {
            HashSet<AclEntryFlag> hashSet = new HashSet<AclEntryFlag>(aclEntryFlagArray.length);
            for (AclEntryFlag aclEntryFlag : aclEntryFlagArray) {
                if (aclEntryFlag == null) {
                    throw new NullPointerException();
                }
                hashSet.add(aclEntryFlag);
            }
            this.flags = hashSet;
            return this;
        }
    }
}

