/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.ArcIterator;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    private int type;

    Arc2D() {
        this(0);
    }

    protected Arc2D(int n) {
        this.setArcType(n);
    }

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double d = Math.toRadians(-this.getAngleStart());
        double d2 = this.getX() + (Math.cos(d) * 0.5 + 0.5) * this.getWidth();
        double d3 = this.getY() + (Math.sin(d) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public Point2D getEndPoint() {
        double d = Math.toRadians(-this.getAngleStart() - this.getAngleExtent());
        double d2 = this.getX() + (Math.cos(d) * 0.5 + 0.5) * this.getWidth();
        double d3 = this.getY() + (Math.sin(d) * 0.5 + 0.5) * this.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public void setArc(Point2D point2D, Dimension2D dimension2D, double d, double d2, int n) {
        this.setArc(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight(), d, d2, n);
    }

    public void setArc(Rectangle2D rectangle2D, double d, double d2, int n) {
        this.setArc(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d2, n);
    }

    public void setArc(Arc2D arc2D) {
        this.setArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.type);
    }

    public void setArcByCenter(double d, double d2, double d3, double d4, double d5, int n) {
        this.setArc(d - d3, d2 - d3, d3 * 2.0, d3 * 2.0, d4, d5, n);
    }

    public void setArcByTangent(Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        double d2 = Math.atan2(point2D.getY() - point2D2.getY(), point2D.getX() - point2D2.getX());
        double d3 = Math.atan2(point2D3.getY() - point2D2.getY(), point2D3.getX() - point2D2.getX());
        double d4 = d3 - d2;
        if (d4 > Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d4 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        double d5 = (d2 + d3) / 2.0;
        double d6 = Math.abs(d3 - d5);
        double d7 = d / Math.sin(d6);
        double d8 = point2D2.getX() + d7 * Math.cos(d5);
        double d9 = point2D2.getY() + d7 * Math.sin(d5);
        if (d2 < d3) {
            d2 -= 1.5707963267948966;
            d3 += 1.5707963267948966;
        } else {
            d2 += 1.5707963267948966;
            d3 -= 1.5707963267948966;
        }
        d2 = Math.toDegrees(-d2);
        d3 = Math.toDegrees(-d3);
        d4 = d3 - d2;
        d4 = d4 < 0.0 ? (d4 += 360.0) : (d4 -= 360.0);
        this.setArcByCenter(d8, d9, d, d2, d4, this.type);
    }

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public void setAngleStart(Point2D point2D) {
        double d = this.getHeight() * (point2D.getX() - this.getCenterX());
        double d2 = this.getWidth() * (point2D.getY() - this.getCenterY());
        this.setAngleStart(-Math.toDegrees(Math.atan2(d2, d)));
    }

    public void setAngles(double d, double d2, double d3, double d4) {
        double d5 = this.getCenterX();
        double d6 = this.getCenterY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        double d9 = Math.atan2(d7 * (d6 - d2), d8 * (d - d5));
        double d10 = Math.atan2(d7 * (d6 - d4), d8 * (d3 - d5));
        if ((d10 -= d9) <= 0.0) {
            d10 += Math.PI * 2;
        }
        this.setAngleStart(Math.toDegrees(d9));
        this.setAngleExtent(Math.toDegrees(d10));
    }

    public void setAngles(Point2D point2D, Point2D point2D2) {
        this.setAngles(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setArcType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid type for Arc: " + n);
        }
        this.type = n;
    }

    @Override
    public void setFrame(double d, double d2, double d3, double d4) {
        this.setArc(d, d2, d3, d4, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    @Override
    public Rectangle2D getBounds2D() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.isEmpty()) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.getArcType() == 2) {
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = 1.0;
            d = 1.0;
            d4 = -1.0;
            d3 = -1.0;
        }
        double d5 = 0.0;
        for (int i = 0; i < 6; ++i) {
            if (i < 4) {
                if (!this.containsAngle(d5 += 90.0)) {
                    continue;
                }
            } else {
                d5 = i == 4 ? this.getAngleStart() : (d5 += this.getAngleExtent());
            }
            double d6 = Math.toRadians(-d5);
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            d = Math.min(d, d7);
            d2 = Math.min(d2, d8);
            d3 = Math.max(d3, d7);
            d4 = Math.max(d4, d8);
        }
        double d9 = this.getWidth();
        double d10 = this.getHeight();
        d3 = (d3 - d) * 0.5 * d9;
        d4 = (d4 - d2) * 0.5 * d10;
        d = this.getX() + (d * 0.5 + 0.5) * d9;
        d2 = this.getY() + (d2 * 0.5 + 0.5) * d10;
        return this.makeBounds(d, d2, d3, d4);
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    static double normalizeDegrees(double d) {
        if (d > 180.0) {
            if (d <= 540.0) {
                d -= 360.0;
            } else if ((d = Math.IEEEremainder(d, 360.0)) == -180.0) {
                d = 180.0;
            }
        } else if (d <= -180.0) {
            if (d > -540.0) {
                d += 360.0;
            } else if ((d = Math.IEEEremainder(d, 360.0)) == -180.0) {
                d = 180.0;
            }
        }
        return d;
    }

    public boolean containsAngle(double d) {
        boolean bl;
        double d2 = this.getAngleExtent();
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = -d2;
        }
        if (d2 >= 360.0) {
            return true;
        }
        d = Arc2D.normalizeDegrees(d) - Arc2D.normalizeDegrees(this.getAngleStart());
        if (bl) {
            d = -d;
        }
        if (d < 0.0) {
            d += 360.0;
        }
        return d >= 0.0 && d < d2;
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        double d5;
        boolean bl;
        double d6 = this.getWidth();
        if (d6 <= 0.0) {
            return false;
        }
        double d7 = (d - this.getX()) / d6 - 0.5;
        double d8 = this.getHeight();
        if (d8 <= 0.0) {
            return false;
        }
        double d9 = (d2 - this.getY()) / d8 - 0.5;
        double d10 = d7 * d7 + d9 * d9;
        if (d10 >= 0.25) {
            return false;
        }
        double d11 = Math.abs(this.getAngleExtent());
        if (d11 >= 360.0) {
            return true;
        }
        boolean bl2 = this.containsAngle(-Math.toDegrees(Math.atan2(d9, d7)));
        if (this.type == 2) {
            return bl2;
        }
        if (bl2) {
            if (d11 >= 180.0) {
                return true;
            }
        } else if (d11 <= 180.0) {
            return false;
        }
        double d12 = Math.toRadians(-this.getAngleStart());
        double d13 = Math.cos(d12);
        boolean bl3 = bl = Line2D.relativeCCW(d13, d5 = Math.sin(d12), d4 = Math.cos(d12 += Math.toRadians(-this.getAngleExtent())), d3 = Math.sin(d12), 2.0 * d7, 2.0 * d9) * Line2D.relativeCCW(d13, d5, d4, d3, 0.0, 0.0) >= 0;
        return bl2 ? !bl : bl;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (d3 <= 0.0 || d4 <= 0.0 || d5 <= 0.0 || d6 <= 0.0) {
            return false;
        }
        double d7 = this.getAngleExtent();
        if (d7 == 0.0) {
            return false;
        }
        double d8 = this.getX();
        double d9 = this.getY();
        double d10 = d8 + d5;
        double d11 = d9 + d6;
        double d12 = d + d3;
        double d13 = d2 + d4;
        if (d >= d10 || d2 >= d11 || d12 <= d8 || d13 <= d9) {
            return false;
        }
        double d14 = this.getCenterX();
        double d15 = this.getCenterY();
        Point2D point2D = this.getStartPoint();
        Point2D point2D2 = this.getEndPoint();
        double d16 = point2D.getX();
        double d17 = point2D.getY();
        double d18 = point2D2.getX();
        double d19 = point2D2.getY();
        if (d15 >= d2 && d15 <= d13 && (d16 < d12 && d18 < d12 && d14 < d12 && d10 > d && this.containsAngle(0.0) || d16 > d && d18 > d && d14 > d && d8 < d12 && this.containsAngle(180.0))) {
            return true;
        }
        if (d14 >= d && d14 <= d12 && (d17 > d2 && d19 > d2 && d15 > d2 && d9 < d13 && this.containsAngle(90.0) || d17 < d13 && d19 < d13 && d15 < d13 && d11 > d2 && this.containsAngle(270.0))) {
            return true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        if (this.type == 2 || Math.abs(d7) > 180.0 ? double_.intersectsLine(d14, d15, d16, d17) || double_.intersectsLine(d14, d15, d18, d19) : double_.intersectsLine(d16, d17, d18, d19)) {
            return true;
        }
        return this.contains(d, d2) || this.contains(d + d3, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2 + d4);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2, d3, d4, null);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), rectangle2D);
    }

    private boolean contains(double d, double d2, double d3, double d4, Rectangle2D rectangle2D) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (!(this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4))) {
            return false;
        }
        if (this.type != 2 || Math.abs(this.getAngleExtent()) <= 180.0) {
            return true;
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(d, d2, d3, d4);
        }
        double d9 = this.getWidth() / 2.0;
        double d10 = this.getHeight() / 2.0;
        double d11 = this.getX() + d9;
        if (rectangle2D.intersectsLine(d11, d8 = this.getY() + d10, d7 = d11 + d9 * Math.cos(d6 = Math.toRadians(-this.getAngleStart())), d5 = d8 + d10 * Math.sin(d6))) {
            return false;
        }
        d7 = d11 + d9 * Math.cos(d6 += Math.toRadians(-this.getAngleExtent()));
        return !rectangle2D.intersectsLine(d11, d8, d7, d5 = d8 + d10 * Math.sin(d6));
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new ArcIterator(this, affineTransform);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        l += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        l += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L;
        l += java.lang.Double.doubleToLongBits(this.getAngleStart()) * 53L;
        l += java.lang.Double.doubleToLongBits(this.getAngleExtent()) * 59L;
        return (int)(l += (long)(this.getArcType() * 61)) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)object;
            return this.getX() == arc2D.getX() && this.getY() == arc2D.getY() && this.getWidth() == arc2D.getWidth() && this.getHeight() == arc2D.getHeight() && this.getAngleStart() == arc2D.getAngleStart() && this.getAngleExtent() == arc2D.getAngleExtent() && this.getArcType() == arc2D.getArcType();
        }
        return false;
    }

    public static class Double
    extends Arc2D
    implements Serializable {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;
        private static final long serialVersionUID = 728264085846882001L;

        public Double() {
            super(0);
        }

        public Double(int n) {
            super(n);
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            super(n);
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
        }

        public Double(Rectangle2D rectangle2D, double d, double d2, int n) {
            super(n);
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
            this.start = d;
            this.extent = d2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.setArcType(n);
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
        }

        @Override
        public void setAngleStart(double d) {
            this.start = d;
        }

        @Override
        public void setAngleExtent(double d) {
            this.extent = d;
        }

        @Override
        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Double(d, d2, d3, d4);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeByte(this.getArcType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            try {
                this.setArcType(objectInputStream.readByte());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidObjectException(illegalArgumentException.getMessage());
            }
        }
    }

    public static class Float
    extends Arc2D
    implements Serializable {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;
        private static final long serialVersionUID = 9130893014586380278L;

        public Float() {
            super(0);
        }

        public Float(int n) {
            super(n);
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            super(n);
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.start = f5;
            this.extent = f6;
        }

        public Float(Rectangle2D rectangle2D, float f, float f2, int n) {
            super(n);
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
            this.start = f;
            this.extent = f2;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        public boolean isEmpty() {
            return (double)this.width <= 0.0 || (double)this.height <= 0.0;
        }

        @Override
        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.setArcType(n);
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.start = (float)d5;
            this.extent = (float)d6;
        }

        @Override
        public void setAngleStart(double d) {
            this.start = (float)d;
        }

        @Override
        public void setAngleExtent(double d) {
            this.extent = (float)d;
        }

        @Override
        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Float((float)d, (float)d2, (float)d3, (float)d4);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeByte(this.getArcType());
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            try {
                this.setArcType(objectInputStream.readByte());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidObjectException(illegalArgumentException.getMessage());
            }
        }
    }
}

