/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginListParser {
    protected PluginInformation createInfo(String name, String url, String manifest) throws PluginListParseException {
        try {
            return new PluginInformation(new ByteArrayInputStream(manifest.getBytes("utf-8")), name.substring(0, name.length() - 4), url);
        }
        catch (UnsupportedEncodingException e) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", name), e);
        }
        catch (PluginException e) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", name), e);
        }
    }

    public List<PluginInformation> parse(InputStream in) throws PluginListParseException {
        LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
        BufferedReader r = null;
        try {
            PluginInformation info;
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            String name = null;
            String url = null;
            StringBuilder manifest = new StringBuilder();
            String line = r.readLine();
            while (line != null) {
                if (line.startsWith("\t")) {
                    if ((line = line.substring(1)).length() > 70) {
                        manifest.append(line.substring(0, 70)).append("\n");
                        line = " " + line.substring(70);
                    }
                    manifest.append(line).append("\n");
                } else {
                    PluginInformation info2;
                    if (name != null && (info2 = this.createInfo(name, url, manifest.toString())) != null) {
                        for (PluginProxy plugin : PluginHandler.pluginList) {
                            if (!plugin.getPluginInformation().name.equals(info2.getName())) continue;
                            info2.localversion = plugin.getPluginInformation().localversion;
                        }
                        ret.add(info2);
                    }
                    String[] x = line.split(";");
                    name = x[0];
                    url = x[1];
                    manifest = new StringBuilder();
                }
                line = r.readLine();
            }
            if (name != null && (info = this.createInfo(name, url, manifest.toString())) != null) {
                for (PluginProxy plugin : PluginHandler.pluginList) {
                    if (!plugin.getPluginInformation().name.equals(info.getName())) continue;
                    info.localversion = plugin.getPluginInformation().localversion;
                }
                ret.add(info);
            }
            return ret;
        }
        catch (IOException e) {
            throw new PluginListParseException(e);
        }
    }
}

