/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerLocationReader
extends OsmServerReader {
    String url;

    public OsmServerLocationReader(String url) {
        this.url = url;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream in = null;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            in = this.getInputStreamRaw(this.url, progressMonitor.createSubTaskMonitor(9, false));
            if (in == null) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
            dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                DataSet dataSet3 = null;
                return dataSet3;
            }
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            try {
                if (in != null) {
                    in.close();
                }
                this.activeConnection = null;
            }
            catch (Exception e) {}
        }
        return dataSet;
    }
}

