/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressException;

public class PleaseWaitProgressMonitor
extends AbstractProgressMonitor {
    private static final int PROGRESS_BAR_MAX = 100;
    private final Window dialogParent;
    private int currentProgressValue = 0;
    private PleaseWaitDialog dialog;
    private String windowTitle;
    private ActionListener cancelListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };
    private WindowListener windowListener = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };

    public PleaseWaitProgressMonitor() {
        this("");
    }

    public PleaseWaitProgressMonitor(String windowTitle) {
        this(Main.parent);
        this.windowTitle = windowTitle;
    }

    public PleaseWaitProgressMonitor(Component dialogParent) {
        super(new CancelHandler());
        this.dialogParent = JOptionPane.getFrameForComponent(dialogParent);
    }

    public PleaseWaitProgressMonitor(Component dialogParent, String windowTitle) {
        this(JOptionPane.getFrameForComponent(dialogParent));
        this.windowTitle = windowTitle;
    }

    private void doInEDT(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public void doBeginTask() {
        this.doInEDT(new Runnable(){

            public void run() {
                if (PleaseWaitProgressMonitor.this.dialogParent instanceof Frame && PleaseWaitProgressMonitor.this.dialog == null) {
                    PleaseWaitProgressMonitor.this.dialog = new PleaseWaitDialog((Component)PleaseWaitProgressMonitor.this.dialogParent);
                } else if (PleaseWaitProgressMonitor.this.dialogParent instanceof Dialog && PleaseWaitProgressMonitor.this.dialog == null) {
                    PleaseWaitProgressMonitor.this.dialog = new PleaseWaitDialog((Component)PleaseWaitProgressMonitor.this.dialogParent);
                } else {
                    throw new ProgressException("PleaseWaitDialog parent must be either Frame or Dialog", new Object[0]);
                }
                if (PleaseWaitProgressMonitor.this.windowTitle != null) {
                    PleaseWaitProgressMonitor.this.dialog.setTitle(PleaseWaitProgressMonitor.this.windowTitle);
                }
                PleaseWaitProgressMonitor.this.dialog.setCancelEnabled(true);
                PleaseWaitProgressMonitor.this.dialog.setCancelCallback(PleaseWaitProgressMonitor.this.cancelListener);
                PleaseWaitProgressMonitor.this.dialog.setCustomText("");
                PleaseWaitProgressMonitor.this.dialog.addWindowListener(PleaseWaitProgressMonitor.this.windowListener);
                ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.progress.setMaximum(100);
                PleaseWaitProgressMonitor.this.dialog.setVisible(true);
            }
        });
    }

    public void doFinishTask() {
    }

    protected void updateProgress(double progressValue) {
        int newValue = (int)(progressValue * 100.0);
        if (newValue != this.currentProgressValue) {
            this.currentProgressValue = newValue;
            this.doInEDT(new Runnable(){

                public void run() {
                    ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.progress.setValue(PleaseWaitProgressMonitor.this.currentProgressValue);
                }
            });
        }
    }

    protected void doSetCustomText(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                PleaseWaitProgressMonitor.this.dialog.setCustomText(title);
            }
        });
    }

    protected void doSetTitle(final String title) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.doInEDT(new Runnable(){

            public void run() {
                ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.currentAction.setText(title);
            }
        });
    }

    protected void doSetIntermediate(final boolean value) {
        this.doInEDT(new Runnable(){

            public void run() {
                if (value && ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.progress.getValue() == 0) {
                    PleaseWaitProgressMonitor.this.dialog.setIndeterminate(true);
                } else {
                    PleaseWaitProgressMonitor.this.dialog.setIndeterminate(false);
                }
            }
        });
    }

    public void appendLogMessage(final String message) {
        this.doInEDT(new Runnable(){

            public void run() {
                PleaseWaitProgressMonitor.this.dialog.appendLogMessage(message);
            }
        });
    }

    public void close() {
        this.dialog.setVisible(false);
        this.dialog.setCancelCallback(null);
        this.dialog.removeWindowListener(this.windowListener);
        this.dialog.dispose();
        this.dialog = null;
    }
}

