/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.StyleSourceEditor;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private StyleSourceEditor sources;
    private JCheckBox sortMenu;
    private JCheckBox enableDefault;
    private PreferenceTabbedPane.ValidationListener validationListener = new PreferenceTabbedPane.ValidationListener(){

        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveStylesChanged()) {
                ArrayList<String> sourcesToRemove = new ArrayList<String>();
                block15: for (String source : TaggingPresetPreference.this.sources.getActiveStyles()) {
                    boolean canLoad = false;
                    try {
                        TaggingPreset.readAll(source, false);
                        canLoad = true;
                    }
                    catch (IOException e) {
                        System.err.println(I18n.tr("Warning: Could not read tagging preset source: {0}", source));
                        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Error"), new String[]{I18n.tr("Yes"), I18n.tr("No"), I18n.tr("Cancel")});
                        ed.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", source));
                        switch (ed.showDialog().getValue()) {
                            case 1: {
                                continue block15;
                            }
                            case 2: {
                                sourcesToRemove.add(source);
                                continue block15;
                            }
                        }
                        return false;
                    }
                    catch (SAXException e) {
                        // empty catch block
                    }
                    String errorMessage = null;
                    try {
                        TaggingPreset.readAll(source, true);
                    }
                    catch (IOException e) {
                        String msg = I18n.tr("Could not read tagging preset source {0}", source);
                        System.err.println(msg);
                        JOptionPane.showMessageDialog(Main.parent, msg);
                        return false;
                    }
                    catch (SAXParseException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), e.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
                    }
                    catch (SAXException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, e.getMessage()) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, e.getMessage());
                    }
                    if (errorMessage == null) continue;
                    System.err.println("Error: " + errorMessage);
                    int result = JOptionPane.showConfirmDialog(Main.parent, new JLabel(errorMessage), I18n.tr("Error"), 1, 0);
                    switch (result) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            sourcesToRemove.add(source);
                            continue block15;
                        }
                    }
                    return false;
                }
                for (String toRemove : sourcesToRemove) {
                    TaggingPresetPreference.this.sources.removeSource(toRemove);
                }
                return true;
            }
            return true;
        }
    };

    public void addGui(final PreferenceTabbedPane gui) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("taggingpreset.enable-defaults", true));
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        panel.add((Component)this.enableDefault, GBC.eol().insets(5, 0, 5, 0));
        this.sources = new StyleSourceEditor("taggingpreset.sources", "taggingpreset.icon.sources", "http://josm.openstreetmap.de/presets");
        panel.add((Component)this.sources, GBC.eol().fill(1));
        gui.mapcontent.addTab(I18n.tr("Tagging Presets"), panel);
        gui.mapcontent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (gui.mapcontent.getSelectedComponent() == panel) {
                    TaggingPresetPreference.this.sources.initiallyLoadAvailableStyles();
                }
            }
        });
        gui.addValidationListener(this.validationListener);
    }

    public boolean ok() {
        boolean restart = Main.pref.put("taggingpreset.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        if (Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null)) {
            restart = true;
        }
        if (this.sources.finish()) {
            restart = true;
        }
        return restart;
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences(false);
        for (TaggingPreset tp : taggingPresets) {
            if (tp instanceof TaggingPresetSeparator) continue;
            Main.toolbar.register(tp);
        }
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            AutoCompletionManager.cachePresets(taggingPresets);
            HashMap<TaggingPresetMenu, JMenu> submenus = new HashMap<TaggingPresetMenu, JMenu>();
            for (TaggingPreset p : taggingPresets) {
                JMenu m;
                JMenu jMenu = m = p.group != null ? (JMenu)submenus.get(p.group) : Main.main.menu.presetsMenu;
                if (p instanceof TaggingPresetSeparator) {
                    m.add(new JSeparator());
                    continue;
                }
                if (p instanceof TaggingPresetMenu) {
                    JMenu submenu = new JMenu(p);
                    submenu.setText(p.getLocaleName());
                    ((TaggingPresetMenu)p).menu = submenu;
                    submenus.put((TaggingPresetMenu)p, submenu);
                    m.add(submenu);
                    continue;
                }
                JMenuItem mi = new JMenuItem(p);
                mi.setText(p.getLocaleName());
                m.add(mi);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

