/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BackupPreference
implements PreferenceSetting {
    private static final BooleanProperty PROP_KEEP_BACKUP = new BooleanProperty("save.keepbackup", false);
    private JCheckBox keepBackup;
    private JCheckBox autosave;
    private final JTextField autosaveInterval = new JTextField(8);
    private final JTextField backupPerLayer = new JTextField(8);

    public void addGui(PreferenceTabbedPane gui) {
        VerticallyScrollablePanel panel = new VerticallyScrollablePanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.autosave = new JCheckBox("Auto save enabled");
        this.autosave.setSelected(AutosaveTask.PROP_AUTOSAVE_ENABLED.get());
        panel.add((Component)this.autosave, GBC.eol());
        final JLabel autosaveIntervalLabel = new JLabel(I18n.tr("Auto save interval (seconds)"));
        panel.add((Component)autosaveIntervalLabel, GBC.std().insets(60, 0, 0, 0));
        this.autosaveInterval.setText(Integer.toString(AutosaveTask.PROP_INTERVAL.get()));
        this.autosaveInterval.setToolTipText(I18n.tr("Default value: {0}", AutosaveTask.PROP_INTERVAL.getDefaultValue()));
        this.autosaveInterval.setMinimumSize(this.autosaveInterval.getPreferredSize());
        panel.add((Component)this.autosaveInterval, GBC.eol().insets(5, 0, 0, 5));
        final JLabel backupPerLayerLabel = new JLabel(I18n.tr("Auto saved files per layer"));
        panel.add((Component)backupPerLayerLabel, GBC.std().insets(60, 0, 0, 0));
        this.backupPerLayer.setText(Integer.toString(AutosaveTask.PROP_FILES_PER_LAYER.get()));
        this.backupPerLayer.setToolTipText(I18n.tr("Default value: {0}", AutosaveTask.PROP_FILES_PER_LAYER.getDefaultValue()));
        this.backupPerLayer.setMinimumSize(this.backupPerLayer.getPreferredSize());
        panel.add((Component)this.backupPerLayer, GBC.eol().insets(5, 0, 0, 10));
        panel.add((Component)new HtmlPanel(I18n.tr("<i>(Autosave stores the changed data layers in periodic intervals. The backups are saved in JOSM''s preference folder. In case of a crash, JOSM tries to recover the unsaved changes on next start.)</i>")), GBC.eop().fill(2).insets(5, 0, 0, 10));
        panel.add((Component)new JSeparator(), GBC.eop().fill(2));
        this.keepBackup = new JCheckBox(I18n.tr("Keep backup files when saving data layers"));
        this.keepBackup.setSelected(PROP_KEEP_BACKUP.get());
        this.keepBackup.setToolTipText(I18n.tr("When saving, keep backup files ending with a ~"));
        panel.add((Component)this.keepBackup, GBC.eop());
        panel.add((Component)new HtmlPanel(I18n.tr("<i>(JOSM can keep a backup file when saving data layers. It appends ''~'' to the file name and saves it in the same folder.)</i>")), GBC.eop().fill(2).insets(5, 0, 0, 0));
        ActionListener autosaveEnabled = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enabled = BackupPreference.this.autosave.isSelected();
                autosaveIntervalLabel.setEnabled(enabled);
                BackupPreference.this.autosaveInterval.setEnabled(enabled);
                backupPerLayerLabel.setEnabled(enabled);
                BackupPreference.this.backupPerLayer.setEnabled(enabled);
            }
        };
        this.autosave.addActionListener(autosaveEnabled);
        autosaveEnabled.actionPerformed(null);
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        JScrollPane sp = new JScrollPane(panel);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        gui.mapcontent.addTab(I18n.tr("File backup"), null, sp, I18n.tr("Configure whether to create backup files"));
    }

    public boolean ok() {
        boolean restartRequired = false;
        PROP_KEEP_BACKUP.put(this.keepBackup.isSelected());
        restartRequired |= AutosaveTask.PROP_AUTOSAVE_ENABLED.put(this.autosave.isSelected());
        AutosaveTask.PROP_FILES_PER_LAYER.parseAndPut(this.backupPerLayer.getText());
        return restartRequired |= AutosaveTask.PROP_INTERVAL.parseAndPut(this.autosaveInterval.getText());
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public BackupPreference createPreferenceSetting() {
            return new BackupPreference();
        }
    }
}

