/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.SimpleNodeElemStyle;

public class IconElemStyle
extends ElemStyle {
    public ImageIcon icon;
    private ImageIcon disabledIcon;
    public boolean annotate;

    public IconElemStyle(IconElemStyle i, long maxScale, long minScale) {
        this.icon = i.icon;
        this.annotate = i.annotate;
        this.priority = i.priority;
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.rules = i.rules;
    }

    public IconElemStyle() {
        this.init();
    }

    public void init() {
        this.icon = null;
        this.priority = 0;
        this.annotate = true;
    }

    public ImageIcon getDisabledIcon() {
        if (this.disabledIcon != null) {
            return this.disabledIcon;
        }
        if (this.icon == null) {
            return null;
        }
        this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(this.icon.getImage()));
        return this.disabledIcon;
    }

    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings settings, MapPainter painter, boolean selected, boolean member) {
        if (painter.isShowIcons()) {
            Node n = (Node)primitive;
            String name = painter.isShowNames() && this.annotate ? painter.getNodeName(n) : null;
            painter.drawNodeIcon(n, painter.isInactive() || n.isDisabled() ? this.getDisabledIcon() : this.icon, selected, member, name);
        } else {
            SimpleNodeElemStyle.INSTANCE.paintPrimitive(primitive, settings, painter, selected, member);
        }
    }
}

