/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;

public class ButtonMarker
extends Marker {
    private Rectangle buttonRectangle;

    public ButtonMarker(LatLon ll, String buttonImage, MarkerLayer parentLayer, double time, double offset) {
        super(ll, "", buttonImage, parentLayer, time, offset);
        this.buttonRectangle = new Rectangle(0, 0, this.symbol.getIconWidth(), this.symbol.getIconHeight());
    }

    public ButtonMarker(LatLon ll, String text, String buttonImage, MarkerLayer parentLayer, double time, double offset) {
        super(ll, text, buttonImage, parentLayer, time, offset);
        this.buttonRectangle = new Rectangle(0, 0, this.symbol.getIconWidth(), this.symbol.getIconHeight());
    }

    public boolean containsPoint(Point p) {
        Point screen = Main.map.mapView.getPoint(this.getEastNorth());
        this.buttonRectangle.setLocation(screen.x + 4, screen.y + 2);
        return this.buttonRectangle.contains(p);
    }

    public void paint(Graphics g, MapView mv, boolean mousePressed, boolean showTextOrIcon) {
        if (!showTextOrIcon) {
            super.paint(g, mv, mousePressed, showTextOrIcon);
            return;
        }
        Point screen = mv.getPoint(this.getEastNorth());
        this.buttonRectangle.setLocation(screen.x + 4, screen.y + 2);
        this.symbol.paintIcon(mv, g, screen.x + 4, screen.y + 2);
        Point mousePosition = mv.getMousePosition();
        Border b = mousePosition != null && mousePressed && this.containsPoint(mousePosition) ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0);
        Insets inset = b.getBorderInsets(mv);
        Rectangle r = new Rectangle(this.buttonRectangle);
        r.grow((inset.top + inset.bottom) / 2, (inset.left + inset.right) / 2);
        b.paintBorder(mv, g, r.x, r.y, r.width, r.height);
        String labelText = this.getText();
        if (labelText != null && showTextOrIcon && Main.pref.getBoolean("marker.buttonlabels", true)) {
            g.drawString(labelText, screen.x + 4, screen.y + 2);
        }
    }
}

