/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.BasicUploadSettingsPanel;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.TagSettingsPanel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadStrategy;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class UploadDialog
extends JDialog
implements PropertyChangeListener,
Preferences.PreferenceChangedListener {
    protected static final Logger logger = Logger.getLogger(UploadDialog.class.getName());
    private static UploadDialog uploadDialog;
    private UploadedObjectsSummaryPanel pnlUploadedObjects;
    private ChangesetManagementPanel pnlChangesetManagement;
    private BasicUploadSettingsPanel pnlBasicUploadSettings;
    private UploadStrategySelectionPanel pnlUploadStrategySelectionPanel;
    private TagSettingsPanel pnlTagSettings;
    private JTabbedPane tpConfigPanels;
    private JButton btnUpload;
    private boolean canceled = false;
    private ChangesetCommentModel changesetCommentModel;

    public static UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.setLayout(new BorderLayout());
        this.pnlUploadedObjects = new UploadedObjectsSummaryPanel();
        pnl.add((Component)this.pnlUploadedObjects, "Center");
        this.tpConfigPanels = new JTabbedPane(){

            public Dimension getPreferredSize() {
                return super.getMinimumSize();
            }
        };
        this.tpConfigPanels.add(new JPanel());
        this.tpConfigPanels.add(new JPanel());
        this.tpConfigPanels.add(new JPanel());
        this.tpConfigPanels.add(new JPanel());
        this.changesetCommentModel = new ChangesetCommentModel();
        this.pnlBasicUploadSettings = new BasicUploadSettingsPanel(this.changesetCommentModel);
        this.tpConfigPanels.setComponentAt(0, this.pnlBasicUploadSettings);
        this.tpConfigPanels.setTitleAt(0, I18n.tr("Settings"));
        this.tpConfigPanels.setToolTipTextAt(0, I18n.tr("Decide how to upload the data and which changeset to use"));
        this.pnlTagSettings = new TagSettingsPanel(this.changesetCommentModel);
        this.tpConfigPanels.setComponentAt(1, this.pnlTagSettings);
        this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset"));
        this.tpConfigPanels.setToolTipTextAt(1, I18n.tr("Apply tags to the changeset data is uploaded to"));
        this.pnlChangesetManagement = new ChangesetManagementPanel(this.changesetCommentModel);
        this.tpConfigPanels.setComponentAt(2, this.pnlChangesetManagement);
        this.tpConfigPanels.setTitleAt(2, I18n.tr("Changesets"));
        this.tpConfigPanels.setToolTipTextAt(2, I18n.tr("Manage open changesets and select a changeset to upload to"));
        this.pnlUploadStrategySelectionPanel = new UploadStrategySelectionPanel();
        this.tpConfigPanels.setComponentAt(3, this.pnlUploadStrategySelectionPanel);
        this.tpConfigPanels.setTitleAt(3, I18n.tr("Advanced"));
        this.tpConfigPanels.setToolTipTextAt(3, I18n.tr("Configure advanced settings"));
        pnl.add((Component)this.tpConfigPanels, "South");
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        UploadAction uploadAction = new UploadAction();
        this.btnUpload = new SideButton(uploadAction);
        pnl.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMap inputMap = this.btnUpload.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "doUpload");
        this.btnUpload.getActionMap().put("doUpload", uploadAction);
        CancelAction cancelAction = new CancelAction();
        pnl.add(new SideButton(cancelAction));
        this.getRootPane().registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/UploadDialog"))));
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/UploadDialog"));
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload to ''{0}''", OsmApi.getOsmApi().getBaseUrl()));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.getContentPane().add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.pnlChangesetManagement.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlUploadStrategySelectionPanel);
        this.pnlUploadStrategySelectionPanel.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlBasicUploadSettings.getUploadParameterSummaryPanel().setConfigurationParameterRequestListener(new ConfigurationParameterRequestHandler(){

            public void handleUploadStrategyConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(3);
            }

            public void handleChangesetConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(2);
            }
        });
        this.pnlBasicUploadSettings.setUploadCommentDownFocusTraversalHandler(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.btnUpload.requestFocusInWindow();
            }
        });
        Main.pref.addPreferenceChangeListener(this);
    }

    public UploadDialog() {
        super((Window)JOptionPane.getFrameForComponent(Main.parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public void setUploadedPrimitives(APIDataSet toUpload) {
        if (toUpload == null) {
            List<OsmPrimitive> emptyList = Collections.emptyList();
            this.pnlUploadedObjects.setUploadedPrimitives(emptyList, emptyList, emptyList);
            return;
        }
        this.pnlUploadedObjects.setUploadedPrimitives(toUpload.getPrimitivesToAdd(), toUpload.getPrimitivesToUpdate(), toUpload.getPrimitivesToDelete());
    }

    public void rememberUserInput() {
        this.pnlBasicUploadSettings.rememberUserInput();
        this.pnlUploadStrategySelectionPanel.rememberUserInput();
    }

    public void startUserInput() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.startUserInput();
        this.pnlTagSettings.startUserInput();
        this.pnlTagSettings.initFromChangeset(this.pnlChangesetManagement.getSelectedChangeset());
        this.pnlUploadStrategySelectionPanel.initFromPreferences();
        UploadParameterSummaryPanel pnl = this.pnlBasicUploadSettings.getUploadParameterSummaryPanel();
        pnl.setUploadStrategySpecification(this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification());
        pnl.setCloseChangesetAfterNextUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        pnl.setNumObjects(this.pnlUploadedObjects.getNumObjectsToUpload());
    }

    public Changeset getChangeset() {
        Changeset cs = this.pnlChangesetManagement.getSelectedChangeset();
        if (cs == null) {
            cs = new Changeset();
        }
        cs.setKeys(this.pnlTagSettings.getTags());
        return cs;
    }

    public void setSelectedChangesetForNextUpload(Changeset cs) {
        this.pnlChangesetManagement.setSelectedChangesetForNextUpload(cs);
    }

    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategySpecification spec = this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification();
        spec.setCloseChangesetAfterUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        return spec;
    }

    protected String getUploadComment() {
        return this.changesetCommentModel.getComment();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 600))).applySafe(this);
            this.startUserInput();
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            Changeset cs = (Changeset)evt.getNewValue();
            if (cs == null) {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset"));
            } else {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of changeset {0}", cs.getId()));
            }
        }
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (e.getKey() == null || !e.getKey().equals("osm-server.url")) {
            return;
        }
        if (e.getNewValue() == null) {
            this.setTitle(I18n.tr("Upload"));
        } else {
            this.setTitle(I18n.tr("Upload to ''{0}''", e.getNewValue()));
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            UploadDialog.this.setCanceled(true);
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowActivated(WindowEvent arg0) {
            if (UploadDialog.this.tpConfigPanels.getSelectedIndex() == 0) {
                UploadDialog.this.pnlBasicUploadSettings.initEditingOfUploadComment();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing"));
        }

        public void actionPerformed(ActionEvent e) {
            UploadDialog.this.setCanceled(true);
            UploadDialog.this.setVisible(false);
        }
    }

    class UploadAction
    extends AbstractAction {
        public UploadAction() {
            this.putValue("Name", I18n.tr("Upload Changes"));
            this.putValue("SmallIcon", ImageProvider.get("upload"));
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives"));
        }

        protected boolean warnUploadComment() {
            ExtendedDialog dlg = new ExtendedDialog((Component)UploadDialog.this, I18n.tr("Please revise upload comment"), new String[]{I18n.tr("Revise"), I18n.tr("Cancel"), I18n.tr("Continue as is")});
            dlg.setContent("<html>" + I18n.tr("Your upload comment is <i>empty</i>, or <i>very short</i>.<br /><br />This is technically allowed, but please consider that many users who are<br />watching changes in their area depend on meaningful changeset comments<br />to understand what is going on!<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.") + "</html>");
            dlg.setButtonIcons(new Icon[]{ImageProvider.get("ok"), ImageProvider.get("cancel"), ImageProvider.overlay((Icon)ImageProvider.get("upload"), new ImageIcon(ImageProvider.get("warning-small").getImage().getScaledInstance(10, 10, 4)), ImageProvider.OverlayPosition.SOUTHEAST)});
            dlg.setToolTipTexts(new String[]{I18n.tr("Return to the previous dialog to enter a more descriptive comment"), I18n.tr("Cancel and return to the previous dialog"), I18n.tr("Ignore this hint and upload anyway")});
            dlg.setIcon(2);
            dlg.toggleEnable("upload_comment_is_empty_or_very_short");
            dlg.setToggleCheckboxText(I18n.tr("Do not show this message again"));
            dlg.setCancelButton(1, 2);
            return dlg.showDialog().getValue() != 3;
        }

        protected void warnIllegalChunkSize() {
            HelpAwareOptionPane.showOptionDialog(UploadDialog.this, I18n.tr("Please enter a valid chunk size first"), I18n.tr("Illegal chunk size"), 0, HelpUtil.ht("/Dialog/UploadDialog#IllegalChunkSize"));
        }

        public void actionPerformed(ActionEvent e) {
            if (UploadDialog.this.getUploadComment().trim().length() < 10 && this.warnUploadComment()) {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(0);
                UploadDialog.this.pnlBasicUploadSettings.initEditingOfUploadComment();
                return;
            }
            UploadStrategySpecification strategy = UploadDialog.this.getUploadStrategySpecification();
            if (strategy.getStrategy().equals((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY) && strategy.getChunkSize() == -1) {
                this.warnIllegalChunkSize();
                UploadDialog.this.tpConfigPanels.setSelectedIndex(0);
                return;
            }
            UploadDialog.this.setCanceled(false);
            UploadDialog.this.setVisible(false);
        }
    }
}

