/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePrimitivesTask
extends PleaseWaitRunnable {
    private static final Logger logger = Logger.getLogger(UpdatePrimitivesTask.class.getName());
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private Collection<? extends OsmPrimitive> toUpdate;
    private OsmDataLayer layer;
    private MultiFetchServerObjectReader multiObjectReader;
    private OsmServerObjectReader objectReader;

    public UpdatePrimitivesTask(OsmDataLayer layer, Collection<? extends OsmPrimitive> toUpdate) throws IllegalArgumentException {
        super(I18n.tr("Update objects"), false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (toUpdate == null) {
            toUpdate = Collections.emptyList();
        }
        this.layer = layer;
        this.toUpdate = toUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        UpdatePrimitivesTask updatePrimitivesTask = this;
        synchronized (updatePrimitivesTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                UpdatePrimitivesTask.this.layer.mergeFrom(UpdatePrimitivesTask.this.ds);
                UpdatePrimitivesTask.this.layer.onPostDownloadFromServer();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected void initMultiFetchReaderWithNodes(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to update ..."));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (osmPrimitive instanceof Node && !osmPrimitive.isNew()) {
                reader.append((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            Way way = (Way)osmPrimitive;
            for (Node node : way.getNodes()) {
                if (node.isNew()) continue;
                reader.append(node);
            }
        }
    }

    protected void initMultiFetchReaderWithWays(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing ways to update ..."));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isNew()) continue;
            reader.append((Way)osmPrimitive);
        }
    }

    protected void initMultiFetchReaderWithRelations(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing relations to update ..."));
        for (OsmPrimitive osmPrimitive : this.toUpdate) {
            if (!(osmPrimitive instanceof Relation) || osmPrimitive.isNew()) continue;
            reader.append((Relation)osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            UpdatePrimitivesTask updatePrimitivesTask = this;
            synchronized (updatePrimitivesTask) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = new MultiFetchServerObjectReader();
            }
            this.initMultiFetchReaderWithNodes(this.multiObjectReader);
            this.initMultiFetchReaderWithWays(this.multiObjectReader);
            this.initMultiFetchReaderWithRelations(this.multiObjectReader);
            DataSet theirDataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            updatePrimitivesTask = this;
            synchronized (updatePrimitivesTask) {
                this.multiObjectReader = null;
            }
            DataSetMerger merger = new DataSetMerger(this.ds, theirDataSet);
            merger.merge();
            for (Way w : this.ds.getWays()) {
                if (this.canceled) {
                    return;
                }
                if (!w.hasIncompleteNodes()) continue;
                UpdatePrimitivesTask updatePrimitivesTask2 = this;
                synchronized (updatePrimitivesTask2) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(w.getId(), OsmPrimitiveType.WAY, true);
                }
                theirDataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                updatePrimitivesTask2 = this;
                synchronized (updatePrimitivesTask2) {
                    this.objectReader = null;
                }
                merger = new DataSetMerger(this.ds, theirDataSet);
                merger.merge();
            }
        }
        catch (Exception e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }
}

