/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseChangesetTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private Exception lastException;
    private Collection<Changeset> changesets;
    private ArrayList<Changeset> closedChangesets;

    public CloseChangesetTask(Collection<Changeset> changesets) {
        super(I18n.tr("Closing changeset"), false);
        if (changesets == null) {
            changesets = new ArrayList<Changeset>();
        }
        this.changesets = changesets;
        this.closedChangesets = new ArrayList();
    }

    @Override
    protected void cancel() {
        this.cancelled = true;
        OsmApi.getOsmApi().cancel();
    }

    @Override
    protected void finish() {
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChangesetCache.getInstance().update(CloseChangesetTask.this.closedChangesets);
            }
        });
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            for (Changeset cs : this.changesets) {
                if (this.cancelled) {
                    return;
                }
                if (cs == null || cs.getId() <= 0 || !cs.isOpen()) continue;
                this.getProgressMonitor().subTask(I18n.tr("Closing changeset {0}", cs.getId()));
                OsmApi.getOsmApi().closeChangeset(cs, this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.closedChangesets.add(cs);
            }
        }
        catch (Exception e) {
            if (this.cancelled) {
                return;
            }
            this.lastException = e;
        }
    }
}

