/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class ChangesetsInActiveDataLayerListModel
extends ChangesetListModel
implements DataSetListener,
MapView.EditLayerChangeListener {
    public ChangesetsInActiveDataLayerListModel(DefaultListSelectionModel selectionModel) {
        super(selectionModel);
    }

    public void dataChanged(DataChangedEvent event) {
        this.initFromDataSet(event.getDataset());
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
        for (OsmPrimitive primitive : event.getPrimitives()) {
            this.addChangeset(new Changeset(primitive.getChangesetId()));
        }
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        for (OsmPrimitive primitive : event.getPrimitives()) {
            this.removeChangeset(new Changeset(primitive.getChangesetId()));
        }
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        if (event instanceof ChangesetIdChangedEvent) {
            ChangesetIdChangedEvent e = (ChangesetIdChangedEvent)event;
            this.removeChangeset(new Changeset(e.getOldChangesetId()));
            this.addChangeset(new Changeset(e.getNewChangesetId()));
        }
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer != null) {
            this.initFromDataSet(newLayer.data);
        } else {
            this.initFromDataSet(null);
        }
    }
}

