/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.LayerChangeListener {
    private JTable userTable;
    private UserTableModel model;
    private SelectUsersPrimitivesAction selectionUsersPrimitivesAction;
    private ShowUserInfoAction showUserInfoAction;

    public UserListDialog() {
        super(I18n.tr("Authors"), "userlist", I18n.tr("Open a list of people working on the selected objects."), Shortcut.registerShortcut("subwindow:authors", I18n.tr("Toggle: {0}", I18n.tr("Authors")), 65, 4, 1), 150);
        this.build();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = this.getButtonPanel(2);
        this.selectionUsersPrimitivesAction = new SelectUsersPrimitivesAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.selectionUsersPrimitivesAction);
        pnl.add(new SideButton(this.selectionUsersPrimitivesAction));
        this.showUserInfoAction = new ShowUserInfoAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.showUserInfoAction);
        pnl.add(new SideButton(this.showUserInfoAction));
        return pnl;
    }

    protected void build() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.model = new UserTableModel();
        this.userTable = new JTable(this.model);
        this.userTable.setSelectionMode(2);
        pnl.add((Component)new JScrollPane(this.userTable), "Center");
        pnl.add((Component)this.buildButtonRow(), "South");
        this.userTable.addMouseListener(new DoubleClickAdapter());
        this.add((Component)pnl, "Center");
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.refresh(newSelection);
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)newLayer).data.getSelected());
        } else {
            this.refresh(null);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }

    public void refresh(Collection<? extends OsmPrimitive> fromPrimitives) {
        this.model.populate(fromPrimitives);
        if (this.model.getRowCount() != 0) {
            this.setTitle(I18n.trn("{0} Author", "{0} Authors", this.model.getRowCount(), this.model.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Authors"));
        }
    }

    @Override
    public void showDialog() {
        super.showDialog();
        Layer layer = Main.main.getActiveLayer();
        if (layer instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)layer).data.getSelected());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserTableModel
    extends DefaultTableModel {
        private ArrayList<UserInfo> data;

        public UserTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Author"), I18n.tr("# Objects"), "%"});
            this.data = new ArrayList();
        }

        protected Map<User, Integer> computeStatistics(Collection<? extends OsmPrimitive> primitives) {
            HashMap<User, Integer> ret = new HashMap<User, Integer>();
            if (primitives == null || primitives.isEmpty()) {
                return ret;
            }
            for (OsmPrimitive osmPrimitive : primitives) {
                if (ret.containsKey(osmPrimitive.getUser())) {
                    ret.put(osmPrimitive.getUser(), ret.get(osmPrimitive.getUser()) + 1);
                    continue;
                }
                ret.put(osmPrimitive.getUser(), 1);
            }
            return ret;
        }

        public void populate(Collection<? extends OsmPrimitive> primitives) {
            Map<User, Integer> statistics = this.computeStatistics(primitives);
            this.data.clear();
            if (primitives != null) {
                for (Map.Entry<User, Integer> entry : statistics.entrySet()) {
                    this.data.add(new UserInfo(entry.getKey(), entry.getValue(), (double)entry.getValue().intValue() / (double)primitives.size()));
                }
            }
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            UserInfo info = this.data.get(row);
            switch (column) {
                case 0: {
                    return info.getName() == null ? "" : info.getName();
                }
                case 1: {
                    return info.count;
                }
                case 2: {
                    return NumberFormat.getPercentInstance().format(info.percent);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void selectPrimitivesOwnedBy(int[] rows) {
            HashSet<User> users = new HashSet<User>();
            for (int index : rows) {
                users.add(this.data.get((int)index).user);
            }
            Collection<OsmPrimitive> selected = Main.main.getCurrentDataSet().getSelected();
            LinkedList<OsmPrimitive> byUser = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive p : selected) {
                if (!users.contains(p.getUser())) continue;
                byUser.add(p);
            }
            Main.main.getCurrentDataSet().setSelected(byUser);
        }

        public List<User> getSelectedUsers(int[] rows) {
            LinkedList<User> ret = new LinkedList<User>();
            if (rows == null || rows.length == 0) {
                return ret;
            }
            for (int row : rows) {
                if (this.data.get((int)row).user == null) continue;
                ret.add(this.data.get((int)row).user);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserInfo
    implements Comparable<UserInfo> {
        public User user;
        public int count;
        public double percent;

        UserInfo(User user, int count, double percent) {
            this.user = user;
            this.count = count;
            this.percent = percent;
        }

        @Override
        public int compareTo(UserInfo o) {
            if (this.count < o.count) {
                return 1;
            }
            if (this.count > o.count) {
                return -1;
            }
            if (this.user == null || this.user.getName() == null) {
                return 1;
            }
            if (o.user == null || o.user.getName() == null) {
                return -1;
            }
            return this.user.getName().compareTo(o.user.getName());
        }

        public String getName() {
            if (this.user == null) {
                return I18n.tr("<new object>");
            }
            return this.user.getName();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                UserListDialog.this.selectionUsersPrimitivesAction.select();
            }
        }
    }

    class ShowUserInfoAction
    extends AbstractInfoAction
    implements ListSelectionListener {
        public ShowUserInfoAction() {
            super(false);
            this.putValue("Name", I18n.tr("Show info"));
            this.putValue("ShortDescription", I18n.tr("Launches a browser with information about the user"));
            this.putValue("SmallIcon", ImageProvider.get("about"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            String url;
            int[] rows = UserListDialog.this.userTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            List<User> users = UserListDialog.this.model.getSelectedUsers(rows);
            if (users.isEmpty()) {
                return;
            }
            if (users.size() > 10) {
                System.out.println(I18n.tr("Warning: only launching info browsers for the first {0} of {1} selected users", 10, users.size()));
            }
            Iterator<User> it = users.iterator();
            for (int num = Math.min(10, users.size()); it.hasNext() && num > 0 && (url = this.createInfoUrl(it.next())) != null; --num) {
                this.launchBrowser(url);
            }
        }

        protected String createInfoUrl(Object infoObject) {
            User user = (User)infoObject;
            try {
                return ShowUserInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(user.getName(), "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create an URL because the encoding ''{0}''<br>was missing on this system.</html>", "UTF-8"), I18n.tr("Missing encoding"), 0);
                return null;
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectUsersPrimitivesAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectUsersPrimitivesAction() {
            this.putValue("Name", I18n.tr("Select"));
            this.putValue("ShortDescription", I18n.tr("Select primitives submitted by this user"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void select() {
            int[] indexes = UserListDialog.this.userTable.getSelectedRows();
            if (indexes == null || indexes.length == 0) {
                return;
            }
            UserListDialog.this.model.selectPrimitivesOwnedBy(UserListDialog.this.userTable.getSelectedRows());
        }

        public void actionPerformed(ActionEvent e) {
            this.select();
        }

        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }
}

