/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM_France_DOM
implements Projection,
ProjectionSubPrefs {
    private static String FortMarigotName = I18n.tr("Guadeloupe Fort-Marigot 1949");
    private static String SainteAnneName = I18n.tr("Guadeloupe Ste-Anne 1948");
    private static String MartiniqueName = I18n.tr("Martinique Fort Desaix 1952");
    private static String Reunion92Name = I18n.tr("Reunion RGR92");
    private static String Guyane92Name = I18n.tr("Guyane RGFG95");
    public static String[] utmGeodesicsNames = new String[]{FortMarigotName, SainteAnneName, MartiniqueName, Reunion92Name, Guyane92Name};
    private Bounds FortMarigotBounds = new Bounds(new LatLon(17.6, -63.25), new LatLon(18.5, -62.5));
    private Bounds SainteAnneBounds = new Bounds(new LatLon(15.8, -61.9), new LatLon(16.6, -60.9));
    private Bounds MartiniqueBounds = new Bounds(new LatLon(14.25, -61.25), new LatLon(15.025, -60.725));
    private Bounds ReunionBounds = new Bounds(new LatLon(-25.92, 37.58), new LatLon(-10.6, 58.27));
    private Bounds GuyaneBounds = new Bounds(new LatLon(2.16, -54.0), new LatLon(9.06, -49.62));
    private Bounds[] utmBounds = new Bounds[]{this.FortMarigotBounds, this.SainteAnneBounds, this.MartiniqueBounds, this.ReunionBounds, this.GuyaneBounds};
    private String FortMarigotEPSG = "EPSG::2969";
    private String SainteAnneEPSG = "EPSG::2970";
    private String MartiniqueEPSG = "EPSG::2973";
    private String ReunionEPSG = "EPSG::2975";
    private String GuyaneEPSG = "EPSG::2972";
    private String[] utmEPSGs = new String[]{this.FortMarigotEPSG, this.SainteAnneEPSG, this.MartiniqueEPSG, this.ReunionEPSG, this.GuyaneEPSG};
    private static final double Xs = 500000.0;
    private static double Ys = 0.0;
    protected double lg0;
    private static int zone;
    private boolean isNorth;
    public static final int DEFAULT_GEODESIC = 0;
    public static int currentGeodesic;
    private static double tx;
    private static double ty;
    private static double tz;
    private static double rx;
    private static double ry;
    private static double rz;
    private static double scaleDiff;
    public static final double epsilon = 1.0E-11;

    private void refresh7ParametersTranslation() {
        if (currentGeodesic == 0) {
            this.set7ParametersTranslation(new double[]{136.596, 248.148, -429.789}, new double[]{0.0, 0.0, 0.0}, 0.0, true, 20);
        } else if (currentGeodesic == 1) {
            this.set7ParametersTranslation(new double[]{-472.29, -5.63, -304.12}, new double[]{0.4362, -0.8374, 0.2563}, 1.8984E-6, true, 20);
        } else if (currentGeodesic == 2) {
            this.set7ParametersTranslation(new double[]{126.926, 547.939, 130.409}, new double[]{-2.7867, 5.16124, -0.85844}, 1.382265E-5, true, 20);
        } else if (currentGeodesic == 3) {
            this.set7ParametersTranslation(new double[]{789.524, -626.486, -89.904}, new double[]{0.6006, 76.7946, -10.5788}, -3.23241E-5, false, 40);
        } else if (currentGeodesic == 4) {
            this.set7ParametersTranslation(new double[]{-193.066, 236.993, 105.447}, new double[]{0.4814, -0.8074, 0.1276}, 1.5649E-6, true, 22);
        }
    }

    private void set7ParametersTranslation(double[] translation, double[] rotation, double scalediff, boolean north, int utmZone) {
        tx = translation[0];
        ty = translation[1];
        tz = translation[2];
        rx = rotation[0] / 206264.80624709636;
        ry = rotation[1] / 206264.80624709636;
        rz = rotation[2] / 206264.80624709636;
        scaleDiff = scalediff;
        this.isNorth = north;
        Ys = this.isNorth ? 0.0 : 1.0E7;
        zone = utmZone;
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon p) {
        if (currentGeodesic < 3) {
            LatLon geo = this.GRS802Hayford(p);
            return this.MTProjection(geo, Ellipsoid.hayford.a, Ellipsoid.hayford.e);
        }
        LatLon geo = new LatLon(Math.toRadians(p.lat()), Math.toRadians(p.lon()));
        return this.MTProjection(geo, Ellipsoid.GRS80.a, Ellipsoid.GRS80.e);
    }

    private LatLon GRS802Hayford(LatLon wgs) {
        double lat = Math.toRadians(wgs.lat());
        double lon = Math.toRadians(wgs.lon());
        double N = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(lat);
        double[] coord = this.invSevenParametersTransformation(X, Y, Z);
        return this.Geographic(coord[0], coord[1], coord[2], Ellipsoid.hayford);
    }

    private LatLon Geographic(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    private EastNorth MTProjection(LatLon coord, double a, double e) {
        double n = 0.9996 * a;
        Ys = coord.lat() >= 0.0 ? 0.0 : 1.0E7;
        double r6d = 0.10471975511965977;
        this.lg0 = r6d * ((double)zone - 0.5) - Math.PI;
        double e2 = e * e;
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] C = new double[]{1.0 - e2 / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0 - 175.0 * e8 / 16384.0, e2 / 8.0 - e4 / 96.0 - 9.0 * e6 / 1024.0 - 901.0 * e8 / 184320.0, 13.0 * e4 / 768.0 + 17.0 * e6 / 5120.0 - 311.0 * e8 / 737280.0, 61.0 * e6 / 15360.0 + 899.0 * e8 / 430080.0, 49561.0 * e8 / 4.128768E7};
        double s = e * Math.sin(coord.lat());
        double l = Math.log(Math.tan(0.7853981633974483 + coord.lat() / 2.0) * Math.pow((1.0 - s) / (1.0 + s), e / 2.0));
        double phi = Math.asin(Math.sin(coord.lon() - this.lg0) / ((Math.exp(l) + Math.exp(-l)) / 2.0));
        double ls = Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        double lambda = Math.atan((Math.exp(l) - Math.exp(-l)) / 2.0 / Math.cos(coord.lon() - this.lg0));
        double north = C[0] * lambda;
        double east = C[0] * ls;
        for (int k = 1; k < 5; ++k) {
            double r = 2.0 * (double)k * lambda;
            double m = 2.0 * (double)k * ls;
            double em = Math.exp(m);
            double en = Math.exp(-m);
            double sr = Math.sin(r) / 2.0 * (em + en);
            double sm = Math.cos(r) / 2.0 * (em - en);
            north += C[k] * sr;
            east += C[k] * sm;
        }
        east *= n;
        north *= n;
        return new EastNorth(east += 500000.0, north += Ys);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth p) {
        if (currentGeodesic < 3) {
            this.MTProjection(p.east(), p.north(), zone, this.isNorth);
            LatLon geo = this.Geographic(p, Ellipsoid.hayford.a, Ellipsoid.hayford.e, 0.0);
            double N = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(geo.lat()) * Math.sin(geo.lat()));
            double X = N * Math.cos(geo.lat()) * Math.cos(geo.lon());
            double Y = N * Math.cos(geo.lat()) * Math.sin(geo.lon());
            double Z = N * (1.0 - Ellipsoid.hayford.e2) * Math.sin(geo.lat());
            double[] coord = this.sevenParametersTransformation(X, Y, Z);
            LatLon wgs = this.cart2LatLon(coord[0], coord[1], coord[2], Ellipsoid.GRS80);
            return new LatLon(Math.toDegrees(wgs.lat()), Math.toDegrees(wgs.lon()));
        }
        LatLon geo = this.Geographic(p, Ellipsoid.GRS80.a, Ellipsoid.GRS80.e, 0.0);
        double N = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(geo.lat()) * Math.sin(geo.lat()));
        double X = N * Math.cos(geo.lat()) * Math.cos(geo.lon());
        double Y = N * Math.cos(geo.lat()) * Math.sin(geo.lon());
        double Z = N * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(geo.lat());
        LatLon wgs = this.cart2LatLon(X, Y, Z, Ellipsoid.GRS80);
        return new LatLon(Math.toDegrees(wgs.lat()), Math.toDegrees(wgs.lon()));
    }

    private void MTProjection(double east, double north, int zone, boolean isNorth) {
        Ys = isNorth ? 0.0 : 1.0E7;
        double r6d = 0.10471975511965977;
        this.lg0 = r6d * ((double)zone - 0.5) - Math.PI;
    }

    public double scaleFactor() {
        return 0.15915494309189535;
    }

    private LatLon Geographic(EastNorth coord, double a, double e, double z) {
        double lt0;
        double s;
        double n = 0.9996 * a;
        double e2 = e * e;
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] C = new double[]{1.0 - e2 / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0 - 175.0 * e8 / 16384.0, e2 / 8.0 + e4 / 48.0 + 7.0 * e6 / 2048.0 + e8 / 61440.0, e4 / 768.0 + 3.0 * e6 / 1280.0 + 559.0 * e8 / 368640.0, 17.0 * e6 / 30720.0 + 283.0 * e8 / 430080.0, 4397.0 * e8 / 4.128768E7};
        double l = (coord.north() - Ys) / (n * C[0]);
        double ls = (coord.east() - 500000.0) / (n * C[0]);
        double l0 = l;
        double ls0 = ls;
        for (int k = 1; k < 5; ++k) {
            double r = 2.0 * (double)k * l0;
            double m = 2.0 * (double)k * ls0;
            double em = Math.exp(m);
            double en = Math.exp(-m);
            double sr = Math.sin(r) / 2.0 * (em + en);
            double sm = Math.cos(r) / 2.0 * (em - en);
            l -= C[k] * sr;
            ls -= C[k] * sm;
        }
        double lon = this.lg0 + Math.atan((Math.exp(ls) - Math.exp(-ls)) / 2.0 / Math.cos(l));
        double phi = Math.asin(Math.sin(l) / ((Math.exp(ls) + Math.exp(-ls)) / 2.0));
        l = Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        double lat = 2.0 * Math.atan(Math.exp(l)) - 1.5707963267948966;
        do {
            lt0 = lat;
        } while (Math.abs((lat = 2.0 * Math.atan(Math.pow((1.0 + (s = e * Math.sin(lat))) / (1.0 - s), e / 2.0) * Math.exp(l)) - 1.5707963267948966) - lt0) >= 1.0E-11);
        return new LatLon(lat, lon);
    }

    private LatLon cart2LatLon(double X, double Y, double Z, Ellipsoid ell) {
        double[] XYZ = new double[]{X, Y, Z};
        LatLon coord = ell.cart2LatLon(XYZ, 1.0E-11);
        return new LatLon(Math.toRadians(coord.lat()), Math.toRadians(coord.lon()));
    }

    private double[] sevenParametersTransformation(double Xa, double Ya, double Za) {
        double Xb = tx + Xa * (1.0 + scaleDiff) + Za * ry - Ya * rz;
        double Yb = ty + Ya * (1.0 + scaleDiff) + Xa * rz - Za * rx;
        double Zb = tz + Za * (1.0 + scaleDiff) + Ya * rx - Xa * ry;
        return new double[]{Xb, Yb, Zb};
    }

    private double[] invSevenParametersTransformation(double Xa, double Ya, double Za) {
        double Xb = (1.0 - scaleDiff) * (-tx + Xa + ((-tz + Za) * -ry - (-ty + Ya) * -rz));
        double Yb = (1.0 - scaleDiff) * (-ty + Ya + ((-tx + Xa) * -rz - (-tz + Za) * -rx));
        double Zb = (1.0 - scaleDiff) * (-tz + Za + ((-ty + Ya) * -rx - (-tx + Xa) * -ry));
        return new double[]{Xb, Yb, Zb};
    }

    @Override
    public String getCacheDirectoryName() {
        return this.toString();
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return this.utmBounds[currentGeodesic];
    }

    @Override
    public String toCode() {
        return this.utmEPSGs[currentGeodesic];
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + currentGeodesic;
    }

    @Override
    public String toString() {
        return I18n.tr("UTM France (DOM)");
    }

    public int getCurrentGeodesic() {
        return currentGeodesic;
    }

    @Override
    public void setupPreferencePanel(JPanel p) {
        JComboBox<String> prefcb = new JComboBox<String>(utmGeodesicsNames);
        prefcb.setSelectedIndex(currentGeodesic);
        p.setLayout(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("UTM Geodesic system")), GBC.std().insets(5, 5, 0, 5));
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add(prefcb, GBC.eop().fill(2));
        p.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel p) {
        Component prefcb = p.getComponent(2);
        if (!(prefcb instanceof JComboBox)) {
            return null;
        }
        currentGeodesic = ((JComboBox)prefcb).getSelectedIndex();
        this.refresh7ParametersTranslation();
        return Collections.singleton(Integer.toString(currentGeodesic + 1));
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (int i = 0; i < this.utmEPSGs.length; ++i) {
            if (!this.utmEPSGs[i].endsWith(code)) continue;
            return Collections.singleton(Integer.toString(i));
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> args) {
        currentGeodesic = 0;
        if (args != null) {
            try {
                String s;
                Iterator<String> i$ = args.iterator();
                if (i$.hasNext() && ((currentGeodesic = Integer.parseInt(s = i$.next()) - 1) < 0 || currentGeodesic > 4)) {
                    currentGeodesic = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.refresh7ParametersTranslation();
    }

    static {
        currentGeodesic = 0;
        tx = 0.0;
        ty = 0.0;
        tz = 0.0;
        rx = 0.0;
        ry = 0.0;
        rz = 0.0;
        scaleDiff = 0.0;
    }
}

