/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class LambertEST
implements Projection {
    public static final double ef = 500000.0;
    public static final double nf = 6375000.0;
    public static final double lat1 = Math.toRadians(59.333333333333336);
    public static final double lat2 = Math.toRadians(58.0);
    public static final double latf = Math.toRadians(57.51755393055556);
    public static final double lonf = Math.toRadians(24.0);
    public static final double a = 6378137.0;
    public static final double ee = 0.08181919104281579;
    public static final double m1 = Math.cos(lat1) / Math.sqrt(1.0 - 0.006694380022900788 * Math.pow(Math.sin(lat1), 2.0));
    public static final double m2 = Math.cos(lat2) / Math.sqrt(1.0 - 0.006694380022900788 * Math.pow(Math.sin(lat2), 2.0));
    public static final double t1 = Math.tan(0.7853981633974483 - lat1 / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(lat1)) / (1.0 + 0.08181919104281579 * Math.sin(lat1)), 0.040909595521407896);
    public static final double t2 = Math.tan(0.7853981633974483 - lat2 / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(lat2)) / (1.0 + 0.08181919104281579 * Math.sin(lat2)), 0.040909595521407896);
    public static final double tf = Math.tan(0.7853981633974483 - latf / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(latf)) / (1.0 + 0.08181919104281579 * Math.sin(latf)), 0.040909595521407896);
    public static final double n = (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
    public static final double f = m1 / (n * Math.pow(t1, n));
    public static final double rf = 6378137.0 * f * Math.pow(tf, n);
    public static final double epsilon = 1.0E-11;

    public EastNorth latlon2eastNorth(LatLon p) {
        double t = Math.tan(0.7853981633974483 - Math.toRadians(p.lat()) / 2.0) / Math.pow((1.0 - 0.08181919104281579 * Math.sin(Math.toRadians(p.lat()))) / (1.0 + 0.08181919104281579 * Math.sin(Math.toRadians(p.lat()))), 0.040909595521407896);
        double r = 6378137.0 * f * Math.pow(t, n);
        double theta = n * (Math.toRadians(p.lon()) - lonf);
        double x = 500000.0 + r * Math.sin(theta);
        double y = 6375000.0 + rf - r * Math.cos(theta);
        return new EastNorth(x, y);
    }

    public static double iterateAngle(double e, double t) {
        double a1 = 0.0;
        double a2 = Math.PI;
        double a = 1.5707963267948966;
        double b = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - e * Math.sin(a)) / (1.0 + e * Math.sin(a)), e / 2.0));
        while (Math.abs(a - b) > 1.0E-11) {
            a = a1 + (a2 - a1) / 2.0;
            b = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - e * Math.sin(a)) / (1.0 + e * Math.sin(a)), e / 2.0));
            if (a1 == a2) {
                return 0.0;
            }
            if (b > a) {
                a1 = a;
                continue;
            }
            a2 = a;
        }
        return b;
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        double r = Math.sqrt(Math.pow(p.getX() - 500000.0, 2.0) + Math.pow(rf - p.getY() + 6375000.0, 2.0)) * Math.signum(n);
        double T = Math.pow(r / (6378137.0 * f), 1.0 / n);
        double theta = Math.atan((p.getX() - 500000.0) / (rf - p.getY() + 6375000.0));
        double y = theta / n + lonf;
        double x = LambertEST.iterateAngle(0.08181919104281579, T);
        return new LatLon(Math.toDegrees(x), Math.toDegrees(y));
    }

    public String toString() {
        return I18n.tr("Lambert Zone (Estonia)");
    }

    public String toCode() {
        return "EPSG:3301";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String getCacheDirectoryName() {
        return "lambertest";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }

    public double getDefaultZoomInPPD() {
        return 0.0;
    }
}

