/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations..."), "downloadreferrers", I18n.tr("Download primitives referring to one of the selected primitives"), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...")), 68, 15), true);
        this.putValue("help", HelpUtil.ht("/Action/Downloadreferrers"));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, Collection<OsmPrimitive> children) throws IllegalArgumentException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(targetLayer, children));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, Map<Long, OsmPrimitiveType> children) throws IllegalArgumentException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(targetLayer, children));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Id > 0 required, got {0}", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        Main.worker.submit(new DownloadReferrersTask(targetLayer, id, type));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || !Main.isDisplayingMapView()) {
            return;
        }
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        if (layer == null) {
            return;
        }
        Collection<OsmPrimitive> primitives = layer.data.getSelected();
        DownloadReferrersAction.downloadReferrers(layer, primitives);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

