/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.Stub;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class InterpreterCodelet
extends Stub {
    private static long instanceSize;
    private static CIntegerField sizeField;
    private static AddressField descriptionField;
    private static CIntegerField bytecodeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("InterpreterCodelet");
        sizeField = type.getCIntegerField("_size");
        descriptionField = type.getAddressField("_description");
        bytecodeField = type.getCIntegerField("_bytecode");
        instanceSize = type.getSize();
    }

    public InterpreterCodelet(Address addr) {
        super(addr);
    }

    public long getSize() {
        return sizeField.getValue(this.addr);
    }

    public Address codeBegin() {
        return this.addr.addOffsetTo(instanceSize);
    }

    public Address codeEnd() {
        return this.addr.addOffsetTo(this.getSize());
    }

    public long codeSize() {
        return this.codeEnd().minus(this.codeBegin());
    }

    public String getDescription() {
        return CStringUtilities.getString(descriptionField.getValue(this.addr));
    }

    public void verify() {
    }

    public void printOn(PrintStream tty) {
        String desc = this.getDescription();
        if (desc != null) {
            tty.print(desc);
        }
        tty.println(" [" + this.codeBegin() + ", " + this.codeEnd() + ")  " + this.codeSize() + " bytes  ");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                InterpreterCodelet.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

