/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.LinuxThreadContextFactory;

class LinuxThread
implements ThreadProxy {
    private LinuxDebugger debugger;
    private int lwp_id;

    LinuxThread(LinuxDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.lwp_id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    LinuxThread(LinuxDebugger debugger, long id) {
        this.debugger = debugger;
        this.lwp_id = (int)id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LinuxThread)) {
            return false;
        }
        return ((LinuxThread)obj).lwp_id == this.lwp_id;
    }

    public int hashCode() {
        return this.lwp_id;
    }

    public String toString() {
        return Integer.toString(this.lwp_id);
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.lwp_id);
        ThreadContext context = LinuxThreadContextFactory.createThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }
}

