/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private final AlgorithmConstraints constraints;
    private final PublicKey trustedPubKey;
    private PublicKey prevPubKey;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = EnumSet.of(CryptoPrimitive.SIGNATURE);
    private static final DisabledAlgorithmConstraints certPathDefaultConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");

    public AlgorithmChecker(TrustAnchor trustAnchor) {
        this(trustAnchor, certPathDefaultConstraints);
    }

    public AlgorithmChecker(AlgorithmConstraints algorithmConstraints) {
        this.prevPubKey = null;
        this.trustedPubKey = null;
        this.constraints = algorithmConstraints;
    }

    public AlgorithmChecker(TrustAnchor trustAnchor, AlgorithmConstraints algorithmConstraints) {
        if (trustAnchor == null) {
            throw new IllegalArgumentException("The trust anchor cannot be null");
        }
        this.trustedPubKey = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
        this.prevPubKey = this.trustedPubKey;
        this.constraints = algorithmConstraints;
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (!bl) {
            this.prevPubKey = this.trustedPubKey != null ? this.trustedPubKey : null;
        } else {
            throw new CertPathValidatorException("forward checking not supported");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        Object object;
        if (!(certificate instanceof X509Certificate) || this.constraints == null) {
            return;
        }
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = X509CertImpl.toImpl((X509Certificate)certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        PublicKey publicKey = x509CertImpl.getPublicKey();
        String string = x509CertImpl.getSigAlgName();
        AlgorithmId algorithmId = null;
        try {
            algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        AlgorithmParameters algorithmParameters = algorithmId.getParameters();
        if (!this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, algorithmParameters)) {
            throw new CertPathValidatorException("Algorithm constraints check failed: " + string);
        }
        boolean[] blArray = x509CertImpl.getKeyUsage();
        if (blArray != null && blArray.length < 9) {
            throw new CertPathValidatorException("incorrect KeyUsage extension");
        }
        if (blArray != null) {
            object = EnumSet.noneOf(CryptoPrimitive.class);
            if (blArray[0] || blArray[1] || blArray[5] || blArray[6]) {
                object.add((CryptoPrimitive)CryptoPrimitive.SIGNATURE);
            }
            if (blArray[2]) {
                object.add((CryptoPrimitive)CryptoPrimitive.KEY_ENCAPSULATION);
            }
            if (blArray[3]) {
                object.add((CryptoPrimitive)CryptoPrimitive.PUBLIC_KEY_ENCRYPTION);
            }
            if (blArray[4]) {
                object.add(CryptoPrimitive.KEY_AGREEMENT);
            }
            if (!object.isEmpty() && !this.constraints.permits((Set<CryptoPrimitive>)object, publicKey)) {
                throw new CertPathValidatorException("algorithm constraints check failed");
            }
        }
        if (this.prevPubKey != null) {
            if (string != null && !this.constraints.permits(SIGNATURE_PRIMITIVE_SET, string, this.prevPubKey, algorithmParameters)) {
                throw new CertPathValidatorException("Algorithm constraints check failed: " + string);
            }
            if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
                if (!(this.prevPubKey instanceof DSAPublicKey)) {
                    throw new CertPathValidatorException("Input key is not of a appropriate type for inheriting parameters");
                }
                object = ((DSAPublicKey)this.prevPubKey).getParams();
                if (object == null) {
                    throw new CertPathValidatorException("Key parameters missing");
                }
                try {
                    BigInteger bigInteger = ((DSAPublicKey)publicKey).getY();
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, object.getP(), object.getQ(), object.getG());
                    publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + generalSecurityException.getMessage(), generalSecurityException);
                }
            }
        }
        this.prevPubKey = publicKey;
    }

    void trySetTrustAnchor(TrustAnchor trustAnchor) {
        if (this.prevPubKey == null) {
            if (trustAnchor == null) {
                throw new IllegalArgumentException("The trust anchor cannot be null");
            }
            this.prevPubKey = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
        }
    }

    static void check(PublicKey publicKey, X509CRL x509CRL) throws CertPathValidatorException {
        X509CRLImpl x509CRLImpl = null;
        try {
            x509CRLImpl = X509CRLImpl.toImpl(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new CertPathValidatorException(cRLException);
        }
        AlgorithmId algorithmId = x509CRLImpl.getSigAlgId();
        AlgorithmChecker.check(publicKey, algorithmId);
    }

    static void check(PublicKey publicKey, AlgorithmId algorithmId) throws CertPathValidatorException {
        AlgorithmParameters algorithmParameters;
        String string = algorithmId.getName();
        if (!certPathDefaultConstraints.permits(SIGNATURE_PRIMITIVE_SET, string, publicKey, algorithmParameters = algorithmId.getParameters())) {
            throw new CertPathValidatorException("algorithm check failed: " + string + " is disabled");
        }
    }
}

