/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Arrays;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;

public final class KrbAsReqBuilder {
    private KDCOptions options;
    private PrincipalName cname;
    private PrincipalName sname;
    private KerberosTime from;
    private KerberosTime till;
    private KerberosTime rtime;
    private HostAddresses addresses;
    private EncryptionKey[] keys;
    private char[] password;
    private EncryptionKey pakey;
    private PAData[] paList;
    int[] eTypes;
    private KrbAsReq req;
    private KrbAsRep rep;
    private State state;

    private KrbAsReqBuilder(PrincipalName principalName) throws KrbException {
        if (principalName.getRealm() == null) {
            principalName.setRealm(Config.getInstance().getDefaultRealm());
        }
        this.cname = principalName;
        this.state = State.INIT;
    }

    public KrbAsReqBuilder(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws KrbException {
        this(principalName);
        this.keys = new EncryptionKey[encryptionKeyArray.length];
        for (int i = 0; i < encryptionKeyArray.length; ++i) {
            this.keys[i] = (EncryptionKey)encryptionKeyArray[i].clone();
        }
        this.eTypes = EType.getDefaults("default_tkt_enctypes", encryptionKeyArray);
    }

    public KrbAsReqBuilder(PrincipalName principalName, char[] cArray) throws KrbException {
        this(principalName);
        this.password = (char[])cArray.clone();
        this.eTypes = EType.getDefaults("default_tkt_enctypes");
    }

    public EncryptionKey[] getKeys() throws KrbException {
        PAData.SaltAndParams saltAndParams;
        int n;
        this.checkState(State.REQ_OK, "Cannot get keys");
        if (this.keys != null) {
            EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.keys.length];
            for (int i = 0; i < this.keys.length; ++i) {
                encryptionKeyArray[i] = (EncryptionKey)this.keys[i].clone();
            }
            return encryptionKeyArray;
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.eTypes.length];
        String string = null;
        for (n = 0; n < this.eTypes.length; ++n) {
            saltAndParams = PAData.getSaltAndParams(this.eTypes[n], this.paList);
            if (saltAndParams.salt == null) continue;
            string = saltAndParams.salt;
            encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.password, saltAndParams.salt, this.eTypes[n], saltAndParams.params);
        }
        if (string == null) {
            string = this.cname.getSalt();
        }
        for (n = 0; n < this.eTypes.length; ++n) {
            if (encryptionKeyArray[n] != null) continue;
            saltAndParams = PAData.getSaltAndParams(this.eTypes[n], this.paList);
            encryptionKeyArray[n] = EncryptionKey.acquireSecretKey(this.password, string, this.eTypes[n], saltAndParams.params);
        }
        return encryptionKeyArray;
    }

    public void setOptions(KDCOptions kDCOptions) {
        this.checkState(State.INIT, "Cannot specify options");
        this.options = kDCOptions;
    }

    public void setTarget(PrincipalName principalName) {
        this.checkState(State.INIT, "Cannot specify target");
        this.sname = principalName;
    }

    public void setAddresses(HostAddresses hostAddresses) {
        this.checkState(State.INIT, "Cannot specify addresses");
        this.addresses = hostAddresses;
    }

    private KrbAsReq build() throws KrbException, IOException {
        return new KrbAsReq(this.pakey, this.options, this.cname, this.sname, this.from, this.till, this.rtime, this.eTypes, this.addresses);
    }

    private KrbAsReqBuilder resolve() throws KrbException, Asn1Exception, IOException {
        if (this.keys != null) {
            this.rep.decryptUsingKeys(this.keys, this.req);
        } else {
            this.rep.decryptUsingPassword(this.password, this.req, this.cname);
        }
        if (this.rep.getPA() != null) {
            if (this.paList == null || this.paList.length == 0) {
                this.paList = this.rep.getPA();
            } else {
                int n = this.rep.getPA().length;
                if (n > 0) {
                    int n2 = this.paList.length;
                    this.paList = Arrays.copyOf(this.paList, this.paList.length + n);
                    System.arraycopy(this.rep.getPA(), 0, this.paList, n2, n);
                }
            }
        }
        return this;
    }

    private KrbAsReqBuilder send() throws KrbException, IOException {
        boolean bl = false;
        KdcComm kdcComm = new KdcComm(this.cname.getRealmAsString());
        while (true) {
            try {
                this.req = this.build();
                this.rep = new KrbAsRep(kdcComm.send(this.req.encoding()));
                return this;
            }
            catch (KrbException krbException) {
                if (!(bl || krbException.returnCode() != 24 && krbException.returnCode() != 25)) {
                    if (Krb5.DEBUG) {
                        System.out.println("KrbAsReqBuilder: PREAUTH FAILED/REQ, re-send AS-REQ");
                    }
                    bl = true;
                    KRBError kRBError = krbException.getError();
                    if (this.password == null) {
                        this.pakey = EncryptionKey.findKey(kRBError.getEType(), this.keys);
                    } else {
                        PAData.SaltAndParams saltAndParams = PAData.getSaltAndParams(kRBError.getEType(), kRBError.getPA());
                        this.pakey = kRBError.getEType() == 0 ? EncryptionKey.acquireSecretKey(this.password, saltAndParams.salt == null ? this.cname.getSalt() : saltAndParams.salt, this.eTypes[0], null) : EncryptionKey.acquireSecretKey(this.password, saltAndParams.salt == null ? this.cname.getSalt() : saltAndParams.salt, kRBError.getEType(), saltAndParams.params);
                    }
                    this.paList = kRBError.getPA();
                    continue;
                }
                throw krbException;
            }
            break;
        }
    }

    public KrbAsReqBuilder action() throws KrbException, Asn1Exception, IOException {
        this.checkState(State.INIT, "Cannot call action");
        this.state = State.REQ_OK;
        return this.send().resolve();
    }

    public Credentials getCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve creds");
        return this.rep.getCreds();
    }

    public sun.security.krb5.internal.ccache.Credentials getCCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve CCreds");
        return this.rep.getCCreds();
    }

    public void destroy() {
        this.state = State.DESTROYED;
        if (this.keys != null) {
            for (EncryptionKey encryptionKey : this.keys) {
                encryptionKey.destroy();
            }
            this.keys = null;
        }
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }

    private void checkState(State state, String string) {
        if (this.state != state) {
            throw new IllegalStateException(string + " at " + (Object)((Object)state) + " state");
        }
    }

    private static enum State {
        INIT,
        REQ_OK,
        DESTROYED;

    }
}

