/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractWatchKey;

abstract class AbstractWatchService
extends WatchService {
    private final LinkedBlockingDeque<WatchKey> pendingKeys = new LinkedBlockingDeque();
    private final WatchKey CLOSE_KEY = new AbstractWatchKey(null){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }
    };
    private volatile boolean closed;
    private Object closeLock = new Object();

    protected AbstractWatchService() {
    }

    abstract WatchKey register(Path var1, WatchEvent.Kind<?>[] var2, WatchEvent.Modifier ... var3) throws IOException;

    final void enqueueKey(WatchKey watchKey) {
        this.pendingKeys.offer(watchKey);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
    }

    private void checkKey(WatchKey watchKey) {
        if (watchKey == this.CLOSE_KEY) {
            this.enqueueKey(watchKey);
        }
        this.checkOpen();
    }

    @Override
    public final WatchKey poll() {
        this.checkOpen();
        WatchKey watchKey = this.pendingKeys.poll();
        this.checkKey(watchKey);
        return watchKey;
    }

    @Override
    public final WatchKey poll(long l, TimeUnit timeUnit) throws InterruptedException {
        this.checkOpen();
        WatchKey watchKey = this.pendingKeys.poll(l, timeUnit);
        this.checkKey(watchKey);
        return watchKey;
    }

    @Override
    public final WatchKey take() throws InterruptedException {
        this.checkOpen();
        WatchKey watchKey = this.pendingKeys.take();
        this.checkKey(watchKey);
        return watchKey;
    }

    final boolean isOpen() {
        return !this.closed;
    }

    final Object closeLock() {
        return this.closeLock;
    }

    abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.implClose();
            this.pendingKeys.clear();
            this.pendingKeys.offer(this.CLOSE_KEY);
        }
    }
}

