/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import sun.jkernel.DownloadManager;
import sun.jkernel.Mutex;

public class BackgroundDownloader {
    public static final String BACKGROUND_DOWNLOAD_PROPERTY = "kernel.background.download";
    public static final String PID_PATH = "tmp" + File.separator + "background.pid";
    private static final int WAIT_TIME = 10000;
    private static Mutex backgroundMutex;

    static synchronized Mutex getBackgroundMutex() {
        if (backgroundMutex == null) {
            backgroundMutex = Mutex.create(DownloadManager.MUTEX_PREFIX + "background");
        }
        return backgroundMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doBackgroundDownloads() {
        if (DownloadManager.isJREComplete()) {
            return;
        }
        if (BackgroundDownloader.getBackgroundMutex().acquire(0)) {
            try {
                BackgroundDownloader.writePid();
                Thread.sleep(10000L);
                DownloadManager.doBackgroundDownloads(false);
                DownloadManager.performCompletionIfNeeded();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                BackgroundDownloader.getBackgroundMutex().release();
            }
        } else {
            System.err.println("Unable to acquire background download mutex.");
            System.exit(1);
        }
    }

    private static void writePid() {
        try {
            File file = new File(DownloadManager.getBundlePath(), PID_PATH);
            file.getParentFile().mkdirs();
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            file.deleteOnExit();
            printStream.println(DownloadManager.getCurrentProcessId());
            printStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static void send(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static boolean getBackgroundDownloadProperty() {
        boolean bl = BackgroundDownloader.getBackgroundDownloadKey();
        if (System.getProperty(BACKGROUND_DOWNLOAD_PROPERTY) != null) {
            bl = Boolean.valueOf(System.getProperty(BACKGROUND_DOWNLOAD_PROPERTY));
        }
        return bl;
    }

    static native boolean getBackgroundDownloadKey();

    static void startBackgroundDownloads() {
        if (!BackgroundDownloader.getBackgroundDownloadProperty()) {
            return;
        }
        while (System.err == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        try {
            String string = "-Dkernel.background.download=false -Xmx256m";
            String string2 = DownloadManager.getBaseDownloadURL();
            if (string2 != null && !string2.equals(DownloadManager.DEFAULT_DOWNLOAD_URL)) {
                string = string + " -Dkernel.download.url=" + string2;
            }
            string = string + " sun.jkernel.BackgroundDownloader";
            final Process process = Runtime.getRuntime().exec("\"" + new File(System.getProperty("java.home"), "bin" + File.separator + "java.exe") + "\" " + string);
            Thread thread = new Thread("kernelOutputReader"){

                @Override
                public void run() {
                    try {
                        InputStream inputStream = process.getInputStream();
                        BackgroundDownloader.send(inputStream, new PrintStream(new ByteArrayOutputStream()));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            Thread thread2 = new Thread("kernelErrorReader"){

                @Override
                public void run() {
                    try {
                        InputStream inputStream = process.getErrorStream();
                        BackgroundDownloader.send(inputStream, new PrintStream(new ByteArrayOutputStream()));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            };
            thread2.setDaemon(true);
            thread2.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BackgroundDownloader.doBackgroundDownloads();
    }
}

