/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.Locale;
import sun.awt.SunHints;
import sun.awt.SunToolkit;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontUtilities;
import sun.font.PhysicalFont;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class FontConfigManager {
    static boolean fontConfigFailed = false;
    private static final FontConfigInfo fcInfo = new FontConfigInfo();
    private static String[] fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    private FcCompFont[] fontConfigFonts;

    public static String[] getFontConfigNames() {
        return fontConfigNames;
    }

    public static Object getFontConfigAAHint() {
        return FontConfigManager.getFontConfigAAHint("sans");
    }

    public static Object getFontConfigAAHint(String string) {
        if (FontUtilities.isWindows) {
            return null;
        }
        int n = FontConfigManager.getFontConfigAASettings(FontConfigManager.getFCLocaleStr(), string);
        if (n < 0) {
            return null;
        }
        return SunHints.Value.get(2, n);
    }

    private static String getFCLocaleStr() {
        Locale locale = SunToolkit.getStartupLocale();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (!string2.equals("")) {
            string = string + "-" + string2;
        }
        return string;
    }

    public static native int getFontConfigVersion();

    public synchronized void initFontConfigFonts(boolean bl) {
        int n;
        if (!(this.fontConfigFonts == null || bl && this.fontConfigFonts[0].allFonts == null)) {
            return;
        }
        if (FontUtilities.isWindows || fontConfigFailed) {
            return;
        }
        long l = 0L;
        if (FontUtilities.isLogging()) {
            l = System.nanoTime();
        }
        String[] stringArray = FontConfigManager.getFontConfigNames();
        FcCompFont[] fcCompFontArray = new FcCompFont[stringArray.length];
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            fcCompFontArray[i] = new FcCompFont();
            fcCompFontArray[i].fcName = stringArray[i];
            n = fcCompFontArray[i].fcName.indexOf(58);
            fcCompFontArray[i].fcFamily = fcCompFontArray[i].fcName.substring(0, n);
            fcCompFontArray[i].jdkName = FontUtilities.mapFcName(fcCompFontArray[i].fcFamily);
            fcCompFontArray[i].style = i % 4;
        }
        FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), fcInfo, fcCompFontArray, bl);
        FontConfigFont fontConfigFont = null;
        for (n = 0; n < fcCompFontArray.length; ++n) {
            FcCompFont fcCompFont = fcCompFontArray[n];
            if (fcCompFont.firstFont == null) {
                if (FontUtilities.isLogging()) {
                    PlatformLogger platformLogger = FontUtilities.getLogger();
                    platformLogger.info("Fontconfig returned no font for " + fcCompFontArray[n].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (fontConfigFont != null) continue;
            fontConfigFont = fcCompFont.firstFont;
        }
        if (fontConfigFont == null) {
            if (FontUtilities.isLogging()) {
                PlatformLogger platformLogger = FontUtilities.getLogger();
                platformLogger.info("Fontconfig returned no fonts at all.");
                return;
            }
        } else if (fontConfigFailed) {
            for (n = 0; n < fcCompFontArray.length; ++n) {
                if (fcCompFontArray[n].firstFont != null) continue;
                fcCompFontArray[n].firstFont = fontConfigFont;
            }
        }
        this.fontConfigFonts = fcCompFontArray;
        if (FontUtilities.isLogging()) {
            PlatformLogger platformLogger = FontUtilities.getLogger();
            long l2 = System.nanoTime();
            platformLogger.info("Time spent accessing fontconfig=" + (l2 - l) / 1000000L + "ms.");
            for (int i = 0; i < this.fontConfigFonts.length; ++i) {
                FcCompFont fcCompFont = this.fontConfigFonts[i];
                platformLogger.info("FC font " + fcCompFont.fcName + " maps to family " + fcCompFont.firstFont.familyName + " in file " + fcCompFont.firstFont.fontFile);
                if (fcCompFont.allFonts == null) continue;
                for (int j = 0; j < fcCompFont.allFonts.length; ++j) {
                    FontConfigFont fontConfigFont2 = fcCompFont.allFonts[j];
                    platformLogger.info("Family=" + fontConfigFont2.familyName + " Style=" + fontConfigFont2.styleStr + " Fullname=" + fontConfigFont2.fullName + " File=" + fontConfigFont2.fontFile);
                }
            }
        }
    }

    public PhysicalFont registerFromFcInfo(FcCompFont fcCompFont) {
        SunFontManager sunFontManager = SunFontManager.getInstance();
        String string = fcCompFont.firstFont.fontFile;
        int n = string.length() - 4;
        if (n <= 0) {
            return null;
        }
        String string2 = string.substring(n).toLowerCase();
        boolean bl = string2.equals(".ttc");
        PhysicalFont physicalFont = sunFontManager.getRegisteredFontFile(string);
        if (physicalFont != null) {
            if (bl) {
                Font2D font2D = sunFontManager.findFont2D(fcCompFont.firstFont.familyName, fcCompFont.style, 0);
                if (font2D instanceof PhysicalFont) {
                    return (PhysicalFont)font2D;
                }
                return null;
            }
            return physicalFont;
        }
        physicalFont = sunFontManager.findJREDeferredFont(fcCompFont.firstFont.familyName, fcCompFont.style);
        if (physicalFont == null && sunFontManager.isDeferredFont(string) && (physicalFont = sunFontManager.initialiseDeferredFont(fcCompFont.firstFont.fontFile)) != null) {
            if (bl) {
                Font2D font2D = sunFontManager.findFont2D(fcCompFont.firstFont.familyName, fcCompFont.style, 0);
                if (font2D instanceof PhysicalFont) {
                    return (PhysicalFont)font2D;
                }
                return null;
            }
            return physicalFont;
        }
        if (physicalFont == null) {
            int n2 = -1;
            int n3 = 6;
            if (string2.equals(".ttf") || bl) {
                n2 = 0;
                n3 = 3;
            } else if (string2.equals(".pfa") || string2.equals(".pfb")) {
                n2 = 1;
                n3 = 4;
            }
            physicalFont = sunFontManager.registerFontFile(fcCompFont.firstFont.fontFile, null, n2, true, n3);
        }
        return physicalFont;
    }

    public CompositeFont getFontConfigFont(String string, int n) {
        Font2D font2D;
        string = string.toLowerCase();
        this.initFontConfigFonts(false);
        FcCompFont fcCompFont = null;
        for (int i = 0; i < this.fontConfigFonts.length; ++i) {
            if (!string.equals(this.fontConfigFonts[i].fcFamily) || n != this.fontConfigFonts[i].style) continue;
            fcCompFont = this.fontConfigFonts[i];
            break;
        }
        if (fcCompFont == null) {
            fcCompFont = this.fontConfigFonts[0];
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("FC name=" + string + " style=" + n + " uses " + fcCompFont.firstFont.familyName + " in file: " + fcCompFont.firstFont.fontFile);
        }
        if (fcCompFont.compFont != null) {
            return fcCompFont.compFont;
        }
        FontManager fontManager = FontManagerFactory.getInstance();
        CompositeFont compositeFont = (CompositeFont)fontManager.findFont2D(fcCompFont.jdkName, n, 2);
        if (fcCompFont.firstFont.familyName == null || fcCompFont.firstFont.fontFile == null) {
            fcCompFont.compFont = compositeFont;
            return fcCompFont.compFont;
        }
        FontFamily fontFamily = FontFamily.getFamily(fcCompFont.firstFont.familyName);
        PhysicalFont physicalFont = null;
        if (fontFamily != null && (font2D = fontFamily.getFontWithExactStyleMatch(fcCompFont.style)) instanceof PhysicalFont) {
            physicalFont = (PhysicalFont)font2D;
        }
        if (physicalFont == null || !fcCompFont.firstFont.fontFile.equals(physicalFont.platName)) {
            physicalFont = this.registerFromFcInfo(fcCompFont);
            if (physicalFont == null) {
                fcCompFont.compFont = compositeFont;
                return fcCompFont.compFont;
            }
            fontFamily = FontFamily.getFamily(physicalFont.getFamilyName(null));
        }
        for (int i = 0; i < this.fontConfigFonts.length; ++i) {
            FcCompFont fcCompFont2 = this.fontConfigFonts[i];
            if (fcCompFont2 == fcCompFont || !physicalFont.getFamilyName(null).equals(fcCompFont2.firstFont.familyName) || fcCompFont2.firstFont.fontFile.equals(physicalFont.platName) || fontFamily.getFontWithExactStyleMatch(fcCompFont2.style) != null) continue;
            this.registerFromFcInfo(this.fontConfigFonts[i]);
        }
        fcCompFont.compFont = new CompositeFont(physicalFont, compositeFont);
        return fcCompFont.compFont;
    }

    public FcCompFont[] getFontConfigFonts() {
        return this.fontConfigFonts;
    }

    private static native void getFontConfig(String var0, FontConfigInfo var1, FcCompFont[] var2, boolean var3);

    void populateFontConfig(FcCompFont[] fcCompFontArray) {
        this.fontConfigFonts = fcCompFontArray;
    }

    FcCompFont[] loadFontConfig() {
        this.initFontConfigFonts(true);
        return this.fontConfigFonts;
    }

    FontConfigInfo getFontConfigInfo() {
        this.initFontConfigFonts(true);
        return fcInfo;
    }

    private static native int getFontConfigAASettings(String var0, String var1);

    public static class FontConfigInfo {
        public int fcVersion;
        public String[] cacheDirs = new String[4];
    }

    public static class FcCompFont {
        public String fcName;
        public String fcFamily;
        public String jdkName;
        public int style;
        public FontConfigFont firstFont;
        public FontConfigFont[] allFonts;
        public CompositeFont compFont;
    }

    public static class FontConfigFont {
        public String familyName;
        public String styleStr;
        public String fullName;
        public String fontFile;
    }
}

