/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.CreatedFontTracker;
import sun.font.FileFontStrike;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public abstract class FileFont
extends PhysicalFont {
    protected boolean useJavaRasterizer = true;
    protected int fileSize;
    protected FontScaler scaler;
    protected boolean checkedNatives;
    protected boolean useNatives;
    protected NativeFont[] nativeFonts;
    protected char[] glyphToCharMap;

    FileFont(String string, Object object) throws FontFormatException {
        super(string, object);
    }

    @Override
    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (!this.checkedNatives) {
            this.checkUseNatives();
        }
        return new FileFontStrike(this, fontStrikeDesc);
    }

    protected boolean checkUseNatives() {
        this.checkedNatives = true;
        return this.useNatives;
    }

    protected abstract void close();

    abstract ByteBuffer readBlock(int var1, int var2);

    @Override
    public boolean canDoStyle(int n) {
        return true;
    }

    void setFileToRemove(File file, CreatedFontTracker createdFontTracker) {
        Disposer.addObjectRecord(this, new CreatedFontFileDisposerRecord(file, createdFontTracker));
    }

    synchronized void deregisterFontAndClearStrikeCache() {
        SunFontManager sunFontManager = SunFontManager.getInstance();
        sunFontManager.deRegisterBadFont(this);
        for (Reference reference : this.strikeCache.values()) {
            FileFontStrike fileFontStrike;
            if (reference == null || (fileFontStrike = (FileFontStrike)reference.get()) == null || fileFontStrike.pScalerContext == 0L) continue;
            this.scaler.invalidateScalerContext(fileFontStrike.pScalerContext);
        }
        this.scaler.dispose();
        this.scaler = FontScaler.getNullScaler();
    }

    @Override
    StrikeMetrics getFontMetrics(long l) {
        try {
            return this.getScaler().getFontMetrics(l);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getFontMetrics(l);
        }
    }

    @Override
    float getGlyphAdvance(long l, int n) {
        try {
            return this.getScaler().getGlyphAdvance(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphAdvance(l, n);
        }
    }

    @Override
    void getGlyphMetrics(long l, int n, Point2D.Float float_) {
        try {
            this.getScaler().getGlyphMetrics(l, n, float_);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            this.getGlyphMetrics(l, n, float_);
        }
    }

    @Override
    long getGlyphImage(long l, int n) {
        try {
            return this.getScaler().getGlyphImage(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphImage(l, n);
        }
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long l, int n) {
        try {
            return this.getScaler().getGlyphOutlineBounds(l, n);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphOutlineBounds(l, n);
        }
    }

    @Override
    GeneralPath getGlyphOutline(long l, int n, float f, float f2) {
        try {
            return this.getScaler().getGlyphOutline(l, n, f, f2);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphOutline(l, n, f, f2);
        }
    }

    @Override
    GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) {
        try {
            return this.getScaler().getGlyphVectorOutline(l, nArray, n, f, f2);
        }
        catch (FontScalerException fontScalerException) {
            this.scaler = FontScaler.getNullScaler();
            return this.getGlyphVectorOutline(l, nArray, n, f, f2);
        }
    }

    protected abstract FontScaler getScaler();

    @Override
    protected long getUnitsPerEm() {
        return this.getScaler().getUnitsPerEm();
    }

    private static class CreatedFontFileDisposerRecord
    implements DisposerRecord {
        File fontFile = null;
        CreatedFontTracker tracker;

        private CreatedFontFileDisposerRecord(File file, CreatedFontTracker createdFontTracker) {
            this.fontFile = file;
            this.tracker = createdFontTracker;
        }

        @Override
        public void dispose() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (CreatedFontFileDisposerRecord.this.fontFile != null) {
                        try {
                            if (CreatedFontFileDisposerRecord.this.tracker != null) {
                                CreatedFontFileDisposerRecord.this.tracker.subBytes((int)CreatedFontFileDisposerRecord.this.fontFile.length());
                            }
                            CreatedFontFileDisposerRecord.this.fontFile.delete();
                            SunFontManager.getInstance().tmpFontFiles.remove(CreatedFontFileDisposerRecord.this.fontFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
    }
}

