/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import sun.dyn.Access;
import sun.dyn.MethodHandleImpl;

public class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle genericInvoker;
    private final MethodHandle[] varargsInvokers;

    public Invokers(Access access, MethodType methodType) {
        Access.check(access);
        this.targetType = methodType;
        this.varargsInvokers = new MethodHandle[methodType.parameterCount() + 1];
    }

    public static MethodType invokerType(MethodType methodType) {
        return methodType.insertParameterTypes(0, MethodHandle.class);
    }

    public MethodHandle exactInvoker() {
        MethodHandle methodHandle = this.exactInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        try {
            methodHandle = MethodHandleImpl.IMPL_LOOKUP.findVirtual(MethodHandle.class, "invoke", this.targetType);
        }
        catch (NoAccessException noAccessException) {
            throw new InternalError("JVM cannot find invoker for " + this.targetType);
        }
        assert (Invokers.invokerType(this.targetType) == methodHandle.type());
        this.exactInvoker = methodHandle;
        return methodHandle;
    }

    public MethodHandle genericInvoker() {
        MethodHandle methodHandle = this.exactInvoker();
        MethodHandle methodHandle2 = this.genericInvoker;
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        MethodType methodType = this.targetType.generic();
        this.genericInvoker = methodHandle2 = MethodHandles.convertArguments(methodHandle, Invokers.invokerType(methodType));
        return methodHandle2;
    }

    public MethodHandle varargsInvoker(int n) {
        MethodHandle methodHandle = this.varargsInvokers[n];
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = this.genericInvoker();
        MethodType methodType = MethodType.genericMethodType(n, true);
        this.varargsInvokers[n] = methodHandle = MethodHandles.spreadArguments(methodHandle2, Invokers.invokerType(methodType));
        return methodHandle;
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }
}

