/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.lang.reflect.Type;
import java.util.Arrays;
import sun.dyn.Access;
import sun.dyn.BoundMethodHandle;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleNatives;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;

public class AdapterMethodHandle
extends BoundMethodHandle {
    private final int conversion;
    private static final Access IMPL_TOKEN = Access.getToken();
    static final int MAX_ARG_ROTATION = 1;

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l, Object object) {
        super(methodType, object, methodType.parameterSlotDepth(1 + AdapterMethodHandle.convArgPos(l)));
        this.conversion = AdapterMethodHandle.convCode(l);
        if (MethodHandleNatives.JVM_SUPPORT) {
            MethodHandleNatives.init(this, methodHandle, AdapterMethodHandle.convArgPos(l));
        }
    }

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l) {
        this(methodHandle, methodType, l, null);
    }

    public static boolean canPairwiseConvert(MethodType methodType, MethodType methodType2) {
        int n = methodType.parameterCount();
        if (n != methodType2.parameterCount()) {
            return false;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Class<?> clazz3;
            Class<?> clazz4 = methodType.parameterType(i);
            if (AdapterMethodHandle.canConvertArgument(clazz4, clazz3 = methodType2.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean canConvertArgument(Class<?> clazz, Class<?> clazz2) {
        if (VerifyType.isNullConversion(clazz, clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return AdapterMethodHandle.canPrimCast(clazz, clazz2);
            }
            return AdapterMethodHandle.canBoxArgument(clazz, clazz2);
        }
        if (clazz2.isPrimitive()) {
            return AdapterMethodHandle.canUnboxArgument(clazz, clazz2);
        }
        return true;
    }

    public static MethodHandle makePairwiseConvert(Access access, MethodType methodType, MethodHandle methodHandle) {
        Type type;
        Object object;
        int n;
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        if (methodType == methodType2) {
            return methodHandle;
        }
        if (!AdapterMethodHandle.canPairwiseConvert(methodType, methodType2)) {
            return null;
        }
        for (n = methodType.parameterCount() - 1; n >= 0 && VerifyType.isNullConversion(object = methodType.parameterType(n), type = methodType2.parameterType(n)); --n) {
        }
        object = methodHandle;
        type = methodType2.changeReturnType(methodType.returnType());
        for (int i = 0; i <= n; ++i) {
            Class<?> clazz;
            Class<?> clazz2 = methodType.parameterType(i);
            if (VerifyType.isNullConversion(clazz2, clazz = ((MethodType)type).parameterType(i))) continue;
            if (i != n) {
                type = ((MethodType)type).changeParameterType(i, clazz2);
            } else {
                assert (VerifyType.isNullConversion(methodType, ((MethodType)type).changeParameterType(i, clazz2)));
                type = methodType;
            }
            object = clazz2.isPrimitive() ? (clazz.isPrimitive() ? AdapterMethodHandle.makePrimCast(access, (MethodType)type, (MethodHandle)object, i, clazz) : AdapterMethodHandle.makeBoxArgument(access, (MethodType)type, (MethodHandle)object, i, clazz)) : (clazz.isPrimitive() ? AdapterMethodHandle.makeUnboxArgument(access, (MethodType)type, (MethodHandle)object, i, clazz) : AdapterMethodHandle.makeCheckCast(access, (MethodType)type, (MethodHandle)object, i, clazz));
            assert (object != null);
            assert (((MethodHandle)object).type() == type);
        }
        if (((MethodHandle)object).type() != methodType) {
            object = AdapterMethodHandle.makeRetypeOnly(IMPL_TOKEN, methodType, (MethodHandle)object);
            assert (object != null);
            assert (n == -1);
        }
        assert (((MethodHandle)object).type() == methodType);
        return object;
    }

    public static MethodHandle makePermutation(Access access, MethodType methodType, MethodHandle methodHandle, int[] nArray) {
        MethodType methodType2 = methodHandle.type();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n != i) {
                bl = false;
            }
            if (n >= 0 && n < methodType.parameterCount()) continue;
            nArray = new int[]{};
            break;
        }
        if (nArray.length != methodType2.parameterCount()) {
            throw MemberName.newIllegalArgumentException("bad permutation: " + Arrays.toString(nArray));
        }
        if (bl) {
            MethodHandle methodHandle2 = AdapterMethodHandle.makePairwiseConvert(access, methodType, methodHandle);
            if (methodHandle2 == null) {
                throw MemberName.newIllegalArgumentException("cannot convert pairwise: " + methodType);
            }
            return methodHandle2;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            throw MemberName.newIllegalArgumentException("bad return conversion for " + methodType);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Class<?> clazz3;
            int n = nArray[i];
            Class<?> clazz4 = methodType.parameterType(n);
            if (VerifyType.isNullConversion(clazz4, clazz3 = methodType2.parameterType(i))) continue;
            throw MemberName.newIllegalArgumentException("bad argument #" + n + " conversion for " + methodType);
        }
        throw new UnsupportedOperationException("NYI");
    }

    private static byte basicType(Class<?> clazz) {
        if (clazz == null) {
            return 14;
        }
        switch (Wrapper.forBasicType(clazz)) {
            case BOOLEAN: {
                return 4;
            }
            case CHAR: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case OBJECT: {
                return 12;
            }
            case VOID: {
                return 14;
            }
        }
        return 99;
    }

    private static int type2size(int n) {
        assert (n >= 4 && n <= 12);
        return n == 11 || n == 7 ? 2 : 1;
    }

    private static int type2size(Class<?> clazz) {
        return AdapterMethodHandle.type2size(AdapterMethodHandle.basicType(clazz));
    }

    private static long insertStackMove(int n) {
        long l = n * MethodHandleNatives.JVM_STACK_MOVE_UNIT;
        return (l & 0xFFFL) << 20;
    }

    private static long makeConv(int n, int n2, int n3, int n4) {
        assert (n3 == (n3 & 0xF));
        assert (n4 == (n4 & 0xF));
        assert (n >= 2 && n <= 5);
        int n5 = AdapterMethodHandle.type2size(n4) - AdapterMethodHandle.type2size(n3);
        return (long)n2 << 32 | (long)n << 8 | (long)(n3 << 16) | (long)(n4 << 12) | AdapterMethodHandle.insertStackMove(n5);
    }

    private static long makeConv(int n, int n2, int n3) {
        assert (n >= 8 && n <= 11);
        int n4 = 0;
        int n5 = 0;
        if (n >= 10 && n <= 11) {
            n5 = 12;
            n4 = 12;
        }
        return (long)n2 << 32 | (long)n << 8 | (long)(n4 << 16) | (long)(n5 << 12) | AdapterMethodHandle.insertStackMove(n3);
    }

    private static long makeSwapConv(int n, int n2, byte by, int n3) {
        assert (n >= 6 && n <= 7);
        return (long)n2 << 32 | (long)n << 8 | (long)(by << 16) | (long)(by << 12) | (long)(n3 << 0);
    }

    private static long makeConv(int n) {
        assert (n == 0 || n == 1);
        return 0xFFFFFFFF00000000L | (long)(n << 8);
    }

    private static int convCode(long l) {
        return (int)l;
    }

    private static int convArgPos(long l) {
        return (int)(l >>> 32);
    }

    private static boolean convOpSupported(int n) {
        assert (n >= 0 && n <= 14);
        return (1 << n & MethodHandleNatives.CONV_OP_IMPLEMENTED_MASK) != 0;
    }

    int conversionOp() {
        return (this.conversion & 0xF00) >> 8;
    }

    private static int diffTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        int n = AdapterMethodHandle.diffReturnTypes(methodType, methodType2, bl);
        if (n != 0) {
            return n;
        }
        int n2 = methodType.parameterCount();
        if (n2 != methodType2.parameterCount()) {
            return -1;
        }
        n = AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n2, bl);
        return n;
    }

    private static int diffReturnTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        Class<?> clazz = methodType2.returnType();
        Class<?> clazz2 = methodType.returnType();
        if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) {
            return 0;
        }
        if (bl && !clazz.isPrimitive() && !clazz2.isPrimitive()) {
            return 0;
        }
        return -1;
    }

    private static int diffParamTypes(MethodType methodType, int n, MethodType methodType2, int n2, int n3, boolean bl) {
        assert (n3 >= 0);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Class<?> clazz = methodType.parameterType(n + i);
            Class<?> clazz2 = methodType2.parameterType(n2 + i);
            if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) continue;
            if (n4 != 0) {
                return -1 - n4;
            }
            n4 = 1 + i;
        }
        return n4;
    }

    public static boolean canRetypeOnly(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetype(methodType, methodType2, false);
    }

    public static boolean canRetypeRaw(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetype(methodType, methodType2, true);
    }

    static boolean canRetype(MethodType methodType, MethodType methodType2, boolean bl) {
        if (!AdapterMethodHandle.convOpSupported(bl ? 1 : 0)) {
            return false;
        }
        int n = AdapterMethodHandle.diffTypes(methodType, methodType2, bl);
        assert (bl || n == 0 == VerifyType.isNullConversion(methodType, methodType2));
        return n == 0;
    }

    public static MethodHandle makeRetypeOnly(Access access, MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetype(access, methodType, methodHandle, false);
    }

    public static MethodHandle makeRetypeRaw(Access access, MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetype(access, methodType, methodHandle, true);
    }

    static MethodHandle makeRetype(Access access, MethodType methodType, MethodHandle methodHandle, boolean bl) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        if (methodType2 == methodType) {
            return methodHandle;
        }
        if (!AdapterMethodHandle.canRetype(methodType, methodType2, bl)) {
            return null;
        }
        return new AdapterMethodHandle(methodHandle, methodType, AdapterMethodHandle.makeConv(bl ? 1 : 0));
    }

    public static boolean canCheckCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(2)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canCheckCast(Class<?> clazz, Class<?> clazz2) {
        return !clazz.isPrimitive() && !clazz2.isPrimitive();
    }

    public static MethodHandle makeCheckCast(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        Access.check(access);
        if (!AdapterMethodHandle.canCheckCast(methodType, methodHandle.type(), n, clazz)) {
            return null;
        }
        long l = AdapterMethodHandle.makeConv(2, n, 12, 12);
        return new AdapterMethodHandle(methodHandle, methodType, l, clazz);
    }

    public static boolean canPrimCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(3)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canPrimCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canPrimCast(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2 || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        if (Wrapper.forPrimitiveType(clazz2).isFloating()) {
            return Wrapper.forPrimitiveType(clazz).isFloating();
        }
        assert (Wrapper.forPrimitiveType(clazz).isIntegral() && Wrapper.forPrimitiveType(clazz2).isIntegral());
        return true;
    }

    public static MethodHandle makePrimCast(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        if (!AdapterMethodHandle.canPrimCast(methodType, methodType2, n, clazz)) {
            return null;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        long l = AdapterMethodHandle.makeConv(3, n, AdapterMethodHandle.basicType(clazz2), AdapterMethodHandle.basicType(clazz));
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    public static boolean canUnboxArgument(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(4)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        clazz = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz4) || clazz4 == clazz || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canUnboxArgument(Class<?> clazz, Class<?> clazz2) {
        return !clazz.isPrimitive() && Wrapper.asPrimitiveType(clazz2).isPrimitive();
    }

    public static MethodHandle makeUnboxArgument(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        Class<?> clazz5 = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canUnboxArgument(methodType, methodType2, n, clazz)) {
            return null;
        }
        MethodType methodType3 = methodType;
        if (!VerifyType.isNullConversion(clazz2, clazz4)) {
            methodType3 = methodType.changeParameterType(n, clazz4);
        }
        long l = AdapterMethodHandle.makeConv(4, n, 12, AdapterMethodHandle.basicType(clazz5));
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType3, l, clazz4);
        if (methodType3 == methodType) {
            return adapterMethodHandle;
        }
        return AdapterMethodHandle.makeCheckCast(access, methodType, adapterMethodHandle, n, clazz4);
    }

    public static boolean canBoxArgument(Class<?> clazz, Class<?> clazz2) {
        if (!AdapterMethodHandle.convOpSupported(5)) {
            return false;
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle makeBoxArgument(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        return null;
    }

    public static boolean canDropArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (n2 == 0) {
            return AdapterMethodHandle.canRetypeOnly(methodType, methodType2);
        }
        if (!AdapterMethodHandle.convOpSupported(9)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - n4;
        if (n < 0 || n >= n3 || n2 < 1 || n4 > n3 || methodType2.parameterCount() != n3 - n2) {
            return false;
        }
        return n5 == 0 || AdapterMethodHandle.diffParamTypes(methodType, n4, methodType2, n, n5, false) == 0;
    }

    public static MethodHandle makeDropArguments(Access access, MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        Access.check(access);
        if (n2 == 0) {
            return AdapterMethodHandle.makeRetypeOnly(IMPL_TOKEN, methodType, methodHandle);
        }
        if (!AdapterMethodHandle.canDropArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        int n3 = n + n2;
        int n4 = methodType.parameterSlotDepth(n3);
        int n5 = methodType.parameterSlotDepth(n);
        int n6 = n5 - n4;
        assert (n6 >= n2);
        assert (methodHandle.type().parameterSlotCount() + n6 == methodType.parameterSlotCount());
        long l = AdapterMethodHandle.makeConv(9, n + n2 - 1, -n6);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    public static boolean canDupArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(8)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n2 < 0 || n + n2 > n3) {
            return false;
        }
        if (methodType2.parameterCount() != n3 + n2) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n3, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n3, n2, false) == 0;
    }

    public static MethodHandle makeDupArguments(Access access, MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        Access.check(access);
        if (!AdapterMethodHandle.canDupArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        if (n2 == 0) {
            return methodHandle;
        }
        int n3 = n + n2;
        int n4 = methodType.parameterSlotDepth(n3);
        int n5 = methodType.parameterSlotDepth(n);
        int n6 = n5 - n4;
        assert (methodHandle.type().parameterSlotCount() - n6 == methodType.parameterSlotCount());
        long l = AdapterMethodHandle.makeConv(8, n + n2 - 1, n6);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    public static boolean canSwapArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(6)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        if (n >= n2) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (methodType2.parameterCount() != n3) {
            return false;
        }
        if (n < 0 || n2 >= n3) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n2, 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n + 1, methodType2, n + 1, n2 - n - 1, false) != 0) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, n2, methodType2, n, 1, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n2 + 1, methodType2, n2 + 1, n3 - n2 - 1, false) == 0;
    }

    public static MethodHandle makeSwapArguments(Access access, MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        Access.check(access);
        if (n == n2) {
            return methodHandle;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (!AdapterMethodHandle.canSwapArguments(methodType, methodHandle.type(), n, n2)) {
            return null;
        }
        Class<?> clazz = methodType.parameterType(n);
        int n4 = methodType.parameterSlotDepth(n2 + 1);
        long l = AdapterMethodHandle.makeSwapConv(6, n, AdapterMethodHandle.basicType(clazz), n4);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    static int positiveRotation(int n, int n2) {
        assert (n > 0);
        if (n2 >= 0) {
            if (n2 < n) {
                return n2;
            }
            return n2 % n;
        }
        if (n2 >= -n) {
            return n2 + n;
        }
        return -1 - (-1 - n2) % n + n;
    }

    public static boolean canRotateArguments(MethodType methodType, MethodType methodType2, int n, int n2, int n3) {
        if (!AdapterMethodHandle.convOpSupported(7)) {
            return false;
        }
        if (n2 <= 2) {
            return false;
        }
        if ((n3 = AdapterMethodHandle.positiveRotation(n2, n3)) == 0) {
            return false;
        }
        if (n3 > 1 && n3 < n2 - 1) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n4 = methodType.parameterCount();
        if (methodType2.parameterCount() != n4) {
            return false;
        }
        if (n < 0 || n >= n4) {
            return false;
        }
        int n5 = n + n2;
        if (n5 > n4) {
            return false;
        }
        if (AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n6 = n2 - n3;
        int n7 = n3;
        if (AdapterMethodHandle.diffParamTypes(methodType, n, methodType2, n5 - n6, n6, false) != 0) {
            return false;
        }
        return AdapterMethodHandle.diffParamTypes(methodType, n + n6, methodType2, n, n7, false) == 0;
    }

    public static MethodHandle makeRotateArguments(Access access, MethodType methodType, MethodHandle methodHandle, int n, int n2, int n3) {
        byte by;
        int n4;
        int n5;
        Access.check(access);
        n3 = AdapterMethodHandle.positiveRotation(n2, n3);
        if (!AdapterMethodHandle.canRotateArguments(methodType, methodHandle.type(), n, n2, n3)) {
            return null;
        }
        int n6 = n + n2;
        int n7 = methodType.parameterSlotDepth(n);
        int n8 = methodType.parameterSlotDepth(n6 - n3);
        int n9 = methodType.parameterSlotDepth(n6);
        int n10 = n7 - n8;
        assert (n10 > 0);
        int n11 = n8 - n9;
        assert (n11 > 0);
        if (n11 <= n10) {
            n5 = n6 - 1;
            n4 = n;
            by = AdapterMethodHandle.basicType(methodType.parameterType(n5));
            assert (n11 == AdapterMethodHandle.type2size(by));
        } else {
            n5 = n;
            n4 = n6 - 1;
            by = AdapterMethodHandle.basicType(methodType.parameterType(n5));
            assert (n10 == AdapterMethodHandle.type2size(by));
        }
        int n12 = methodType.parameterSlotDepth(n4 + 1);
        long l = AdapterMethodHandle.makeSwapConv(7, n5, by, n12);
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    public static boolean canSpreadArguments(MethodType methodType, MethodType methodType2, Class<?> clazz, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(11)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - (n + 1);
        if (n < 0 || n >= n3 || n2 < 0 || methodType2.parameterCount() != n4 + n5) {
            return false;
        }
        if (n5 != 0 && AdapterMethodHandle.diffParamTypes(methodType, n + 1, methodType2, n4, n5, false) != 0) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        if (clazz2 != clazz && !AdapterMethodHandle.canCheckCast(clazz2, clazz)) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz3 = VerifyType.spreadArgElementType(clazz, i);
            Class<?> clazz4 = methodType2.parameterType(n + i);
            if (clazz3 != null && VerifyType.isNullConversion(clazz3, clazz4)) continue;
            return false;
        }
        return true;
    }

    public static MethodHandle makeSpreadArguments(Access access, MethodType methodType, MethodHandle methodHandle, Class<?> clazz, int n, int n2) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        if (!AdapterMethodHandle.canSpreadArguments(methodType, methodType2, clazz, n, n2)) {
            return null;
        }
        int n3 = n + n2;
        int n4 = methodType2.parameterSlotDepth(n3);
        int n5 = methodType2.parameterSlotDepth(n);
        int n6 = n5 - n4;
        assert (n4 == methodType.parameterSlotDepth(n + 1));
        assert (n6 >= n2);
        long l = AdapterMethodHandle.makeConv(11, n, n6 - 1);
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType, l, clazz);
        assert (adapterMethodHandle.type().parameterType(n) == clazz);
        return adapterMethodHandle;
    }

    @Override
    public String toString() {
        return AdapterMethodHandle.nonAdapter((MethodHandle)this.vmtarget).toString();
    }

    private static MethodHandle nonAdapter(MethodHandle methodHandle) {
        while (methodHandle instanceof AdapterMethodHandle) {
            methodHandle = (MethodHandle)methodHandle.vmtarget;
        }
        return methodHandle;
    }
}

