/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

public abstract class BaseRowSet
implements Serializable,
Cloneable {
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private transient String username;
    private transient String password;
    private int rowSetType = 1004;
    private boolean showDeleted = false;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int concurrency = 1008;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir = 1000;
    private int fetchSize = 0;
    private Map map;
    private Vector listeners = new Vector();
    private Hashtable params;
    static final long serialVersionUID = 4886719666485113312L;

    protected void initParams() {
        this.params = new Hashtable();
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    private void checkforRowSetInterface() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException("The class extending abstract class BaseRowSet must implement javax.sql.RowSet or one of it's sub-interfaces.");
        }
    }

    protected void notifyCursorMoved() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }

    protected void notifyRowChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
            }
        }
    }

    protected void notifyRowSetChanged() throws SQLException {
        this.checkforRowSetInterface();
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) throws SQLException {
        if (string == null) {
            this.command = null;
        } else {
            if (string.length() == 0) {
                throw new SQLException("Invalid command string detected. Cannot be of length less than 0");
            }
            if (this.params == null) {
                throw new SQLException("Set initParams() before setCommand");
            }
            this.params.clear();
            this.command = string;
        }
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public void setUrl(String string) throws SQLException {
        if (string == null) {
            string = null;
        } else {
            if (string.length() < 1) {
                throw new SQLException("Invalid url string detected. Cannot be of length less than 1");
            }
            this.URL = string;
        }
        this.dataSource = null;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String string) throws SQLException {
        if (string == null) {
            this.dataSource = null;
        } else {
            if (string.equals("")) {
                throw new SQLException("DataSource name cannot be empty string");
            }
            this.dataSource = string;
        }
        this.URL = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string == null ? null : string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string == null ? null : string;
    }

    public void setType(int n) throws SQLException {
        if (n != 1003 && n != 1004 && n != 1005) {
            throw new SQLException("Invalid type of RowSet set. Must be either ResultSet.TYPE_FORWARD_ONLY or ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_SCROLL_SENSITIVE.");
        }
        this.rowSetType = n;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public void setConcurrency(int n) throws SQLException {
        if (n != 1007 && n != 1008) {
            throw new SQLException("Invalid concurrency set. Must be either ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE.");
        }
        this.concurrency = n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 0 && n != 2 && n != 1 && n != 4 && n != 8) {
            throw new SQLException("Invalid transaction isolation set. Must be either Connection.TRANSACTION_NONE or Connection.TRANSACTION_READ_UNCOMMITTED or Connection.TRANSACTION_READ_COMMITTED or Connection.RRANSACTION_REPEATABLE_READ or Connection.TRANSACTION_SERIALIZABLE");
        }
        this.isolation = n;
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.map;
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        this.map = map;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid max field size set. Cannot be of value: " + n);
        }
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid max row size set. Cannot be of value: " + n);
        }
        if (n < this.getFetchSize()) {
            throw new SQLException("Invalid max row size set. Cannot be less than the fetchSize.");
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid query timeout value set. Cannot be of value: " + n);
        }
        this.queryTimeout = n;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.getType() == 1003 && n != 1000 || n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.fetchDir = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.getMaxRows() == 0 && n >= 0) {
            this.fetchSize = n;
            return;
        }
        if (n < 0 || n > this.getMaxRows()) {
            throw new SQLException("Invalid fetch size set. Cannot be of value: " + n);
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private void checkParamIndex(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid Parameter Index");
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, n2};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{null, n2, string};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setNull");
        }
        this.params.put(n - 1, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setByte");
        }
        this.params.put(n - 1, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setShort");
        }
        this.params.put(n - 1, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setInt");
        }
        this.params.put(n - 1, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setLong");
        }
        this.params.put(n - 1, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setFloat");
        }
        this.params.put(n - 1, new Float(f));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDouble");
        }
        this.params.put(n - 1, new Double(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBigDecimal");
        }
        this.params.put(n - 1, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setString");
        }
        this.params.put(n - 1, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBytes");
        }
        this.params.put(n - 1, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(n - 1, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(n - 1, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(n - 1, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, n2, 2};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setAsciiStream");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, n2, 1};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBinaryStream");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, n2, 0};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setUnicodeStream");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{reader, n2};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setCharacterStream");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, n2, n3};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, n2};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setObject");
        }
        this.params.put(n - 1, object);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setRef");
        }
        this.params.put(n - 1, new SerialRef(ref));
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setBlob");
        }
        this.params.put(n - 1, new SerialBlob(blob));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setClob");
        }
        this.params.put(n - 1, new SerialClob(clob));
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParamIndex(n);
        if (this.params == null) {
            throw new SQLException("Set initParams() before setArray");
        }
        this.params.put(n - 1, new SerialArray(array));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setDate");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTime");
        }
        this.params.put(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        if (this.params == null) {
            throw new SQLException("Set initParams() before setTimestamp");
        }
        this.params.put(n - 1, objectArray);
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        if (this.params == null) {
            this.initParams();
            Object[] objectArray = new Object[this.params.size()];
            return objectArray;
        }
        Object[] objectArray = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            objectArray[i] = this.params.get(i);
            if (objectArray[i] != null) continue;
            throw new SQLException("missing parameter: " + (i + 1));
        }
        return objectArray;
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String string, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }
}

