/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final Random seedGenerator = new Random();
    private static final int MAX_HELP_DEPTH = 8;
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY;
    final ForkJoinPool pool;
    private ForkJoinTask<?>[] queue;
    private volatile int base;
    private int sp;
    private int stealHint;
    volatile int runState;
    private static final int TERMINATING = 1;
    private static final int TERMINATED = 2;
    private static final int SUSPENDED = 4;
    private static final int TRIMMED = 8;
    int stealCount;
    private int seed;
    boolean active;
    private final boolean locallyFifo;
    int poolIndex;
    int lastEventCount;
    volatile long nextWaiter;
    int spareCount;
    volatile int nextSpare;
    private volatile ForkJoinTask<?> currentJoin;
    private volatile ForkJoinTask<?> currentSteal;
    private static final Unsafe UNSAFE;
    private static final long spOffset;
    private static final long runStateOffset;
    private static final long currentJoinOffset;
    private static final long currentStealOffset;
    private static final long qBase;
    private static final long poolRunStateOffset;
    private static final int qShift;

    protected ForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
        this.pool = forkJoinPool;
        this.locallyFifo = forkJoinPool.locallyFifo;
        this.setDaemon(true);
    }

    final void start(int n, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.poolIndex = n;
        if (uncaughtExceptionHandler != null) {
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        this.start();
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    protected void onStart() {
        int n = seedGenerator.nextInt();
        this.seed = n == 0 ? 1 : n;
        String string = Integer.toString(this.pool.getPoolNumber());
        String string2 = Integer.toString(this.poolIndex);
        this.setName("ForkJoinPool-" + string + "-worker-" + string2);
        this.queue = new ForkJoinTask[8192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable throwable) {
        try {
            ForkJoinPool forkJoinPool = this.pool;
            if (this.active) {
                int n;
                this.active = false;
                while (!UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n = forkJoinPool.runState, n - 1)) {
                }
            }
            this.cancelTasks();
            this.setTerminated();
            forkJoinPool.workerTerminated(this);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            }
        }
        finally {
            if (throwable != null) {
                UNSAFE.throwException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable throwable = null;
        try {
            this.onStart();
            this.mainLoop();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            this.onTermination(throwable);
        }
    }

    private void mainLoop() {
        boolean bl = false;
        ForkJoinPool forkJoinPool = this.pool;
        while (true) {
            forkJoinPool.preStep(this, bl);
            if (this.runState != 0) break;
            bl = this.tryExecSteal() || this.tryExecSubmission();
        }
    }

    private boolean tryExecSteal() {
        ForkJoinTask<?> forkJoinTask = this.scan();
        if (forkJoinTask != null) {
            forkJoinTask.quietlyExec();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
            if (this.sp != this.base) {
                this.execLocalTasks();
            }
            return true;
        }
        return false;
    }

    private boolean tryExecSubmission() {
        ForkJoinPool forkJoinPool = this.pool;
        while (forkJoinPool.hasQueuedSubmissions()) {
            ForkJoinTask<?> forkJoinTask;
            int n;
            if (!this.active && !(this.active = UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n = forkJoinPool.runState, n + 1)) || (forkJoinTask = forkJoinPool.pollSubmission()) == null) continue;
            UNSAFE.putOrderedObject(this, currentStealOffset, forkJoinTask);
            forkJoinTask.quietlyExec();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
            if (this.sp != this.base) {
                this.execLocalTasks();
            }
            return true;
        }
        return false;
    }

    private void execLocalTasks() {
        while (this.runState == 0) {
            ForkJoinTask<?> forkJoinTask;
            ForkJoinTask<?> forkJoinTask2 = forkJoinTask = this.locallyFifo ? this.locallyDeqTask() : this.popTask();
            if (forkJoinTask != null) {
                forkJoinTask.quietlyExec();
                continue;
            }
            if (this.sp != this.base) continue;
            break;
        }
    }

    private static final boolean casSlotNull(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        return UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n << qShift) + qBase, forkJoinTask, null);
    }

    private static final void writeSlot(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        UNSAFE.putObjectVolatile(forkJoinTaskArray, (long)(n << qShift) + qBase, forkJoinTask);
    }

    final void pushTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = forkJoinTaskArray.length - 1;
        int n2 = this.sp++;
        UNSAFE.putOrderedObject(forkJoinTaskArray, (long)((n2 & n) << qShift) + qBase, forkJoinTask);
        if ((n2 -= this.base) == 0) {
            this.pool.signalWork();
        } else if (n2 == n) {
            this.growQueue();
        }
    }

    final ForkJoinTask<?> deqTask() {
        int n = this.base;
        if (this.sp != n) {
            int n2;
            ForkJoinTask<?> forkJoinTask;
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            if (this.queue != null && (forkJoinTask = forkJoinTaskArray[n2 = forkJoinTaskArray.length - 1 & n]) != null && this.base == n && UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n2 << qShift) + qBase, forkJoinTask, null)) {
                this.base = n + 1;
                return forkJoinTask;
            }
        }
        return null;
    }

    final ForkJoinTask<?> locallyDeqTask() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray != null) {
            int n;
            while (this.sp != (n = this.base)) {
                int n2 = forkJoinTaskArray.length - 1 & n;
                ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n2];
                if (forkJoinTask == null || this.base != n || !UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)(n2 << qShift) + qBase, forkJoinTask, null)) continue;
                this.base = n + 1;
                return forkJoinTask;
            }
        }
        return null;
    }

    private ForkJoinTask<?> popTask() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray != null) {
            int n;
            while ((n = this.sp) != this.base) {
                int n2 = forkJoinTaskArray.length - 1 & --n;
                long l = (long)(n2 << qShift) + qBase;
                ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n2];
                if (forkJoinTask == null) break;
                if (!UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                this.sp = n;
                return forkJoinTask;
            }
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = this.sp;
        if (n != this.base && forkJoinTaskArray != null && UNSAFE.compareAndSwapObject(forkJoinTaskArray, (long)((forkJoinTaskArray.length - 1 & --n) << qShift) + qBase, forkJoinTask, null)) {
            this.sp = n;
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray == null) {
            return null;
        }
        int n = forkJoinTaskArray.length - 1;
        int n2 = this.locallyFifo ? this.base : this.sp - 1;
        return forkJoinTaskArray[n2 & n];
    }

    private void growQueue() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = forkJoinTaskArray.length;
        int n2 = n << 1;
        if (n2 > MAXIMUM_QUEUE_CAPACITY) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.queue = new ForkJoinTask[n2];
        ForkJoinTask[] forkJoinTaskArray2 = this.queue;
        int n3 = this.base;
        int n4 = n3 + n;
        int n5 = n - 1;
        int n6 = n2 - 1;
        do {
            int n7;
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = forkJoinTaskArray[n7 = n3 & n5]) != null && !ForkJoinWorkerThread.casSlotNull(forkJoinTaskArray, n7, forkJoinTask)) {
                forkJoinTask = null;
            }
            ForkJoinWorkerThread.writeSlot(forkJoinTaskArray2, n3 & n6, forkJoinTask);
        } while (++n3 != n4);
        this.pool.signalWork();
    }

    private static final int xorShift(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        return n ^ n << 5;
    }

    private ForkJoinTask<?> scan() {
        int n;
        ForkJoinPool forkJoinPool = this.pool;
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = forkJoinPool.workers;
        if (forkJoinPool.workers != null && (n = forkJoinWorkerThreadArray.length) > 1) {
            boolean bl = this.active;
            int n2 = this.seed;
            int n3 = n - 1;
            int n4 = -n;
            int n5 = n2;
            while (true) {
                int n6;
                ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[n5 & n3];
                n2 ^= n2 << 13;
                n2 ^= n2 >>> 17;
                n2 ^= n2 << 5;
                if (forkJoinWorkerThread != null && (n6 = forkJoinWorkerThread.base) != forkJoinWorkerThread.sp) {
                    ForkJoinTask<?>[] forkJoinTaskArray = forkJoinWorkerThread.queue;
                    if (forkJoinWorkerThread.queue != null) {
                        int n7 = forkJoinTaskArray.length - 1 & n6;
                        long l = (long)(n7 << qShift) + qBase;
                        int n8 = this.poolIndex;
                        ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n7];
                        if (forkJoinTask != null) {
                            int n9;
                            if (!bl && UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n9 = forkJoinPool.runState, n9 + 1)) {
                                this.active = true;
                                bl = true;
                            }
                            if (bl && forkJoinWorkerThread.base == n6++ && UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                                forkJoinWorkerThread.base = n6;
                                forkJoinWorkerThread.stealHint = n8;
                                UNSAFE.putOrderedObject(this, currentStealOffset, forkJoinTask);
                                this.seed = n2;
                                ++this.stealCount;
                                return forkJoinTask;
                            }
                        }
                        n4 = -n;
                        n5 = n2;
                        continue;
                    }
                }
                if (++n4 <= 0) {
                    n5 = n2;
                    continue;
                }
                if (n4 > n) break;
                n5 += n >>> 1 | 1;
            }
        }
        return null;
    }

    final boolean isRunning() {
        return this.runState == 0;
    }

    final boolean isTerminated() {
        return (this.runState & 2) != 0;
    }

    final boolean isSuspended() {
        return (this.runState & 4) != 0;
    }

    final boolean isTrimmed() {
        return (this.runState & 8) != 0;
    }

    final boolean isTerminating() {
        if ((this.runState & 1) != 0) {
            return true;
        }
        if (this.pool.isAtLeastTerminating()) {
            this.shutdown();
            return true;
        }
        return false;
    }

    final void shutdown() {
        int n;
        while (((n = this.runState) & 3) == 0 && !((n & 4) != 0 ? UNSAFE.compareAndSwapInt(this, runStateOffset, n, n & 0xFFFFFFFB | 9) : UNSAFE.compareAndSwapInt(this, runStateOffset, n, n | 1))) {
        }
    }

    private void setTerminated() {
        int n;
        while (!UNSAFE.compareAndSwapInt(this, runStateOffset, n = this.runState, n | 3)) {
        }
    }

    final boolean tryUnsuspend() {
        int n;
        while (((n = this.runState) & 4) != 0) {
            if (!UNSAFE.compareAndSwapInt(this, runStateOffset, n, n & 0xFFFFFFFB)) continue;
            return true;
        }
        return false;
    }

    final void suspendAsSpare() {
        while (true) {
            int n;
            if (((n = this.runState) & 1) != 0) {
                if (!UNSAFE.compareAndSwapInt(this, runStateOffset, n, n | 9)) continue;
                return;
            }
            if (UNSAFE.compareAndSwapInt(this, runStateOffset, n, n | 4)) break;
        }
        ForkJoinPool forkJoinPool = this.pool;
        forkJoinPool.pushSpare(this);
        while ((this.runState & 4) != 0) {
            if (!forkJoinPool.tryAccumulateStealCount(this)) continue;
            ForkJoinWorkerThread.interrupted();
            if ((this.runState & 4) == 0) break;
            LockSupport.park(this);
        }
    }

    final int getQueueSize() {
        int n = -this.base + this.sp;
        return n <= 0 ? 0 : n;
    }

    final void cancelTasks() {
        ForkJoinTask<?> forkJoinTask;
        ForkJoinTask<?> forkJoinTask2 = this.currentJoin;
        if (forkJoinTask2 != null) {
            this.currentJoin = null;
            forkJoinTask2.cancelIgnoringExceptions();
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if ((forkJoinTask = this.currentSteal) != null) {
            this.currentSteal = null;
            forkJoinTask.cancelIgnoringExceptions();
        }
        while (this.base != this.sp) {
            ForkJoinTask<?> forkJoinTask3 = this.deqTask();
            if (forkJoinTask3 == null) continue;
            forkJoinTask3.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        while (this.base != this.sp) {
            ForkJoinTask<?> forkJoinTask = this.deqTask();
            if (forkJoinTask == null) continue;
            collection.add(forkJoinTask);
            ++n;
        }
        return n;
    }

    final ForkJoinTask<?> pollLocalTask() {
        ForkJoinPool forkJoinPool = this.pool;
        while (this.sp != this.base) {
            int n;
            if (!this.active && !(this.active = UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n = forkJoinPool.runState, n + 1))) continue;
            return this.locallyFifo ? this.locallyDeqTask() : this.popTask();
        }
        return null;
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> forkJoinTask = this.pollLocalTask();
        if (forkJoinTask == null) {
            forkJoinTask = this.scan();
            UNSAFE.putOrderedObject(this, currentStealOffset, null);
        }
        return forkJoinTask;
    }

    final void joinTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?> forkJoinTask2 = this.currentJoin;
        UNSAFE.putOrderedObject(this, currentJoinOffset, forkJoinTask);
        if (this.sp != this.base) {
            this.localHelpJoinTask(forkJoinTask);
        }
        if (forkJoinTask.status >= 0) {
            this.pool.awaitJoin(forkJoinTask, this);
        }
        UNSAFE.putOrderedObject(this, currentJoinOffset, forkJoinTask2);
    }

    private void localHelpJoinTask(ForkJoinTask<?> forkJoinTask) {
        int n;
        while (forkJoinTask.status >= 0 && (n = this.sp) != this.base) {
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            if (this.queue == null) break;
            int n2 = forkJoinTaskArray.length - 1 & --n;
            long l = (long)(n2 << qShift) + qBase;
            ForkJoinTask<?> forkJoinTask2 = forkJoinTaskArray[n2];
            if (forkJoinTask2 == null) break;
            if (!UNSAFE.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask2, null)) continue;
            if (forkJoinTask.status < 0) {
                UNSAFE.putObjectVolatile(forkJoinTaskArray, l, forkJoinTask2);
                break;
            }
            this.sp = n;
            forkJoinTask2.quietlyExec();
        }
    }

    final void helpJoinTask(ForkJoinTask<?> forkJoinTask) {
        int n;
        if (forkJoinTask.status < 0) {
            return;
        }
        if ((this.runState & 1) != 0) {
            forkJoinTask.cancelIgnoringExceptions();
            return;
        }
        ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.pool.workers;
        if (this.pool.workers == null || (n = forkJoinWorkerThreadArray.length) <= 1) {
            return;
        }
        ForkJoinTask<?> forkJoinTask2 = forkJoinTask;
        ForkJoinWorkerThread forkJoinWorkerThread = this;
        for (int i = 0; i < 8; ++i) {
            Object object;
            int n2;
            ForkJoinWorkerThread forkJoinWorkerThread2 = forkJoinWorkerThreadArray[forkJoinWorkerThread.stealHint & n - 1];
            if (forkJoinWorkerThread2 == null || forkJoinWorkerThread2.currentSteal != forkJoinTask2) {
                n2 = 0;
                while (true) {
                    if (n2 < n) {
                        forkJoinWorkerThread2 = forkJoinWorkerThreadArray[n2];
                        if (forkJoinWorkerThread2 != null && (object = forkJoinWorkerThread2.currentSteal) != null) {
                            if (forkJoinTask.status < 0 || forkJoinTask2.status < 0) {
                                return;
                            }
                            if (object == forkJoinTask2) {
                                forkJoinWorkerThread.stealHint = n2;
                                break;
                            }
                        }
                    } else {
                        return;
                    }
                    ++n2;
                }
            }
            while (true) {
                if (forkJoinTask.status < 0) {
                    return;
                }
                n2 = forkJoinWorkerThread2.base;
                object = forkJoinWorkerThread2.queue;
                if (n2 == forkJoinWorkerThread2.sp || object == null) break;
                int n3 = ((ForkJoinTask<?>[])object).length - 1 & n2;
                long l = (long)(n3 << qShift) + qBase;
                ForkJoinTask<?> forkJoinTask3 = object[n3];
                int n4 = this.poolIndex;
                ForkJoinTask<?> forkJoinTask4 = this.currentSteal;
                if (forkJoinTask2.status < 0) {
                    return;
                }
                if (forkJoinTask3 == null || forkJoinWorkerThread2.base != n2++ || !UNSAFE.compareAndSwapObject(object, l, forkJoinTask3, null)) continue;
                if (forkJoinTask.status < 0) {
                    UNSAFE.putObjectVolatile(object, l, forkJoinTask3);
                    return;
                }
                forkJoinWorkerThread2.base = n2;
                forkJoinWorkerThread2.stealHint = n4;
                UNSAFE.putOrderedObject(this, currentStealOffset, forkJoinTask3);
                forkJoinTask3.quietlyExec();
                UNSAFE.putOrderedObject(this, currentStealOffset, forkJoinTask4);
            }
            ForkJoinTask<?> forkJoinTask5 = forkJoinWorkerThread2.currentJoin;
            if (forkJoinTask2.status < 0 || forkJoinTask5 == null || forkJoinTask5 == forkJoinTask2 || forkJoinTask.status < 0) {
                return;
            }
            forkJoinTask2 = forkJoinTask5;
            forkJoinWorkerThread = forkJoinWorkerThread2;
        }
    }

    final int getEstimatedSurplusTaskCount() {
        return this.sp - this.base - this.pool.idlePerActive();
    }

    final void helpQuiescePool() {
        int n;
        ForkJoinPool forkJoinPool;
        ForkJoinTask<?> forkJoinTask = this.currentSteal;
        while (true) {
            ForkJoinTask<?> forkJoinTask2;
            if ((forkJoinTask2 = this.pollLocalTask()) != null || (forkJoinTask2 = this.scan()) != null) {
                forkJoinTask2.quietlyExec();
                continue;
            }
            forkJoinPool = this.pool;
            if (this.active) {
                n = forkJoinPool.runState;
                if (!UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n, n - 1)) continue;
                this.active = false;
                UNSAFE.putOrderedObject(this, currentStealOffset, forkJoinTask);
            }
            if (forkJoinPool.isQuiescent()) break;
        }
        this.active = true;
        while (!UNSAFE.compareAndSwapInt(forkJoinPool, poolRunStateOffset, n = forkJoinPool.runState, n + 1)) {
        }
    }

    private static long objectFieldOffset(String string, Class<?> clazz) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    static {
        UNSAFE = Unsafe.getUnsafe();
        spOffset = ForkJoinWorkerThread.objectFieldOffset("sp", ForkJoinWorkerThread.class);
        runStateOffset = ForkJoinWorkerThread.objectFieldOffset("runState", ForkJoinWorkerThread.class);
        currentJoinOffset = ForkJoinWorkerThread.objectFieldOffset("currentJoin", ForkJoinWorkerThread.class);
        currentStealOffset = ForkJoinWorkerThread.objectFieldOffset("currentSteal", ForkJoinWorkerThread.class);
        qBase = UNSAFE.arrayBaseOffset(ForkJoinTask[].class);
        poolRunStateOffset = ForkJoinWorkerThread.objectFieldOffset("runState", ForkJoinPool.class);
        int n = UNSAFE.arrayIndexScale(ForkJoinTask[].class);
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        qShift = 31 - Integer.numberOfLeadingZeros(n);
        MAXIMUM_QUEUE_CAPACITY = 1 << 31 - qShift;
    }
}

