/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file.spi;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.FileRef;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public abstract class FileSystemProvider {
    private static final Object lock = new Object();
    private static volatile List<FileSystemProvider> installedProviders;
    private static boolean loadingProviders;

    private static Void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("fileSystemProvider"));
        }
        return null;
    }

    private FileSystemProvider(Void void_) {
    }

    protected FileSystemProvider() {
        this(FileSystemProvider.checkPermission());
    }

    private static List<FileSystemProvider> loadInstalledProviders() {
        ArrayList<FileSystemProvider> arrayList = new ArrayList<FileSystemProvider>();
        ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class, ClassLoader.getSystemClassLoader());
        for (FileSystemProvider fileSystemProvider : serviceLoader) {
            String string = fileSystemProvider.getScheme();
            if (string.equalsIgnoreCase("file")) continue;
            boolean bl = false;
            for (FileSystemProvider fileSystemProvider2 : arrayList) {
                if (!fileSystemProvider2.getScheme().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(fileSystemProvider);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileSystemProvider> installedProviders() {
        if (installedProviders == null) {
            FileSystemProvider fileSystemProvider = FileSystems.getDefault().provider();
            Object object = lock;
            synchronized (object) {
                if (installedProviders == null) {
                    if (loadingProviders) {
                        throw new Error("Circular loading of installed providers detected");
                    }
                    loadingProviders = true;
                    List<FileSystemProvider> list = AccessController.doPrivileged(new PrivilegedAction<List<FileSystemProvider>>(){

                        @Override
                        public List<FileSystemProvider> run() {
                            return FileSystemProvider.loadInstalledProviders();
                        }
                    });
                    list.add(0, fileSystemProvider);
                    installedProviders = Collections.unmodifiableList(list);
                }
            }
        }
        return installedProviders;
    }

    public abstract String getScheme();

    public abstract FileSystem newFileSystem(URI var1, Map<String, ?> var2) throws IOException;

    public abstract FileSystem getFileSystem(URI var1);

    public abstract Path getPath(URI var1);

    public FileSystem newFileSystem(FileRef fileRef, Map<String, ?> map) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> set, ExecutorService executorService, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        loadingProviders = false;
    }
}

