/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodHandleProvider;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.MethodHandleImpl;

public abstract class MethodHandle
extends MethodHandleImpl
implements MethodHandleProvider {
    private static Access IMPL_TOKEN = Access.getToken();
    private MethodType type;

    public final MethodType type() {
        return this.type;
    }

    protected MethodHandle(Access access, MethodType methodType) {
        super(access);
        Access.check(access);
        this.type = methodType;
    }

    private void initType(MethodType methodType) {
        methodType.getClass();
        if (this.type != null) {
            throw new InternalError();
        }
        this.type = methodType;
    }

    public String toString() {
        return MethodHandleImpl.getNameString(IMPL_TOKEN, this);
    }

    @PolymorphicSignature
    public final native <R, A> R invokeExact(A ... var1) throws Throwable;

    @PolymorphicSignature
    public final native <R, A> R invoke(A ... var1) throws Throwable;

    @PolymorphicSignature
    public final native <R, A> R invokeGeneric(A ... var1) throws Throwable;

    public final Object invokeVarargs(Object ... objectArray) throws Throwable {
        MethodHandle methodHandle;
        int n = objectArray == null ? 0 : objectArray.length;
        MethodType methodType = this.type();
        if (n <= 10) {
            methodHandle = MethodHandles.invokers(methodType).genericInvoker();
            switch (n) {
                case 0: {
                    return methodHandle.invokeExact(this);
                }
                case 1: {
                    return methodHandle.invokeExact(this, objectArray[0]);
                }
                case 2: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1]);
                }
                case 3: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2]);
                }
                case 4: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                }
                case 5: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
                }
                case 6: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5]);
                }
                case 7: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6]);
                }
                case 8: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7]);
                }
                case 9: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8]);
                }
                case 10: {
                    return methodHandle.invokeExact(this, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7], objectArray[8], objectArray[9]);
                }
            }
        }
        methodHandle = MethodHandles.invokers(methodType).varargsInvoker(0);
        return methodHandle.invokeExact(this, objectArray);
    }

    public final Object invokeVarargs(List<?> list) throws Throwable {
        return this.invokeVarargs(list.toArray());
    }

    public final MethodHandle asType(MethodType methodType) {
        return MethodHandles.convertArguments(this, methodType);
    }

    public final MethodHandle asSpreader(int n) {
        MethodType methodType = this.type();
        int n2 = methodType.parameterCount();
        MethodType methodType2 = methodType.dropParameterTypes(n, n2);
        methodType2 = methodType2.insertParameterTypes(n, Object[].class);
        return MethodHandles.spreadArguments(this, methodType2);
    }

    public final MethodHandle asCollector(int n) {
        MethodType methodType = this.type();
        int n2 = methodType.parameterCount();
        MethodType methodType2 = methodType.dropParameterTypes(n2 - 1, n2);
        methodType2 = methodType2.insertParameterTypes(n2 - 1, MethodType.genericMethodType(n).parameterArray());
        return MethodHandles.collectArguments(this, methodType2);
    }

    public final MethodHandle bindTo(Object object) {
        return MethodHandles.insertArguments(this, 0, object);
    }

    @Override
    public final MethodHandle asMethodHandle() {
        return this;
    }

    @Override
    public final MethodHandle asMethodHandle(MethodType methodType) {
        return this.asType(methodType);
    }

    static {
        MethodHandleImpl.setMethodHandleFriend(IMPL_TOKEN, new MethodHandleImpl.MethodHandleFriend(){

            @Override
            public void initType(MethodHandle methodHandle, MethodType methodType) {
                methodHandle.initType(methodType);
            }
        });
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

