/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.StreamSOAPCodec;
import com.sun.xml.internal.ws.message.stream.StreamHeader;
import com.sun.xml.internal.ws.message.stream.StreamHeader12;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

final class StreamSOAP12Codec
extends StreamSOAPCodec {
    public static final String SOAP12_MIME_TYPE = "application/soap+xml";
    public static final String SOAP12_CONTENT_TYPE = "application/soap+xml;charset=utf-8";
    private static final List<String> expectedContentTypes = Collections.singletonList("application/soap+xml");
    public static final ContentTypeImpl defaultContentType = new ContentTypeImpl("application/soap+xml;charset=utf-8");

    StreamSOAP12Codec() {
        super(SOAPVersion.SOAP_12);
    }

    @Override
    public String getMimeType() {
        return SOAP12_MIME_TYPE;
    }

    @Override
    protected final StreamHeader createHeader(XMLStreamReader reader, XMLStreamBuffer mark) {
        return new StreamHeader12(reader, mark);
    }

    @Override
    protected com.sun.xml.internal.ws.api.pipe.ContentType getContentType(String soapAction) {
        if (soapAction == null) {
            return defaultContentType;
        }
        return new ContentTypeImpl("application/soap+xml;charset=utf-8;action=" + this.fixQuotesAroundSoapAction(soapAction));
    }

    @Override
    public void decode(InputStream in, String contentType, Packet packet, AttachmentSet att) throws IOException {
        ContentType ct = new ContentType(contentType);
        packet.soapAction = this.fixQuotesAroundSoapAction(ct.getParameter("action"));
        super.decode(in, contentType, packet, att);
    }

    private String fixQuotesAroundSoapAction(String soapAction) {
        if (!(soapAction == null || soapAction.startsWith("\"") && soapAction.endsWith("\""))) {
            String fixedSoapAction = soapAction;
            if (!soapAction.startsWith("\"")) {
                fixedSoapAction = "\"" + fixedSoapAction;
            }
            if (!soapAction.endsWith("\"")) {
                fixedSoapAction = fixedSoapAction + "\"";
            }
            return fixedSoapAction;
        }
        return soapAction;
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return expectedContentTypes;
    }
}

