/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileAttributeView;
import com.sun.nio.zipfs.ZipFileSystem;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.nio.file.FileRef;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.Attributes;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributeView;
import java.nio.file.attribute.FileStoreSpaceAttributes;
import java.util.Formatter;

public class ZipFileStore
extends FileStore {
    private final ZipFileSystem zfs;

    ZipFileStore(ZipPath zipPath) {
        this.zfs = zipPath.getFileSystem();
    }

    @Override
    public String name() {
        return this.zfs.toString() + "/";
    }

    @Override
    public String type() {
        return "zipfs";
    }

    @Override
    public boolean isReadOnly() {
        return this.zfs.isReadOnly();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        return clazz == BasicFileAttributeView.class || clazz == ZipFileAttributeView.class;
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        return string.equals("basic") || string.equals("zip");
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz == FileStoreSpaceAttributeView.class) {
            return (V)new ZipFileStoreAttributeView(this);
        }
        return null;
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        if (string.equals("space:totalSpace")) {
            return new ZipFileStoreAttributeView(this).readAttributes().totalSpace();
        }
        if (string.equals("space:usableSpace")) {
            return new ZipFileStoreAttributeView(this).readAttributes().usableSpace();
        }
        if (string.equals("space:unallocatedSpace")) {
            return new ZipFileStoreAttributeView(this).readAttributes().unallocatedSpace();
        }
        throw new UnsupportedOperationException("does not support the given attribute");
    }

    private static class ZipFileStoreAttributeView
    implements FileStoreSpaceAttributeView {
        private final ZipFileStore fileStore;

        public ZipFileStoreAttributeView(ZipFileStore zipFileStore) {
            this.fileStore = zipFileStore;
        }

        public String name() {
            return "space";
        }

        public FileStoreSpaceAttributes readAttributes() throws IOException {
            final String string = this.fileStore.name();
            Path path = FileSystems.getDefault().getPath(string);
            final long l = Attributes.readBasicFileAttributes((FileRef)path, (LinkOption[])new LinkOption[0]).size();
            final FileStore fileStore = path.getFileStore();
            final FileStoreSpaceAttributes fileStoreSpaceAttributes = Attributes.readFileStoreSpaceAttributes((FileStore)fileStore);
            return new FileStoreSpaceAttributes(){

                public long totalSpace() {
                    return l;
                }

                public long usableSpace() {
                    if (!fileStore.isReadOnly()) {
                        return fileStoreSpaceAttributes.usableSpace();
                    }
                    return 0L;
                }

                public long unallocatedSpace() {
                    if (!fileStore.isReadOnly()) {
                        return fileStoreSpaceAttributes.unallocatedSpace();
                    }
                    return 0L;
                }

                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder();
                    Formatter formatter = new Formatter(stringBuilder);
                    formatter.format("FileStoreSpaceAttributes[%s]%n", string);
                    formatter.format("      totalSpace: %d%n", this.totalSpace());
                    formatter.format("     usableSpace: %d%n", this.usableSpace());
                    formatter.format("    unallocSpace: %d%n", this.unallocatedSpace());
                    formatter.close();
                    return stringBuilder.toString();
                }
            };
        }
    }
}

