/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.ArchetypeInfo;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.navigator.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.wizards.MavenAddArchetypeDialog;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilder;

public class MavenModuleWizardStep
extends ModuleWizardStep {
    private static final Icon WIZARD_ICON = IconLoader.getIcon((String)"/addmodulewizard.png");
    private static final String INHERIT_GROUP_ID_KEY = "MavenModuleWizard.inheritGroupId";
    private static final String INHERIT_VERSION_KEY = "MavenModuleWizard.inheritVersion";
    private static final String ARCHETYPE_ARTIFACT_ID_KEY = "MavenModuleWizard.archetypeArtifactIdKey";
    private static final String ARCHETYPE_GROUP_ID_KEY = "MavenModuleWizard.archetypeGroupIdKey";
    private static final String ARCHETYPE_VERSION_KEY = "MavenModuleWizard.archetypeVersionKey";
    private final Project myProjectOrNull;
    private final MavenModuleBuilder myBuilder;
    private MavenProject myAggregator;
    private MavenProject myParent;
    private String myInheritedGroupId;
    private String myInheritedVersion;
    private JPanel myMainPanel;
    private JLabel myAggregatorLabel;
    private JLabel myAggregatorNameLabel;
    private JButton mySelectAggregator;
    private JLabel myParentLabel;
    private JLabel myParentNameLabel;
    private JButton mySelectParent;
    private JTextField myGroupIdField;
    private JCheckBox myInheritGroupIdCheckBox;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JCheckBox myInheritVersionCheckBox;
    private JCheckBox myUseArchetypeCheckBox;
    private JButton myAddArchetypeButton;
    private JScrollPane myArchetypesScrollPane;
    private JPanel myArchetypesPanel;
    private Tree myArchetypesTree;
    private JScrollPane myArchetypeDescriptionScrollPane;
    private JTextArea myArchetypeDescriptionField;
    private AtomicBoolean myLoadingCancelled;
    private AsyncProcessIcon myLoadingIcon;

    public MavenModuleWizardStep(@Nullable Project project, MavenModuleBuilder builder) {
        this.$$$setupUI$$$();
        this.myLoadingCancelled = new AtomicBoolean();
        this.myLoadingIcon = new AsyncProcessIcon.Big(((Object)((Object)this)).getClass() + ".loading");
        this.myProjectOrNull = project;
        this.myBuilder = builder;
        this.initComponents();
        this.loadSettings();
    }

    private void initComponents() {
        this.myArchetypesTree = new Tree();
        this.myArchetypesTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myArchetypesScrollPane = new JScrollPane((Component)this.myArchetypesTree);
        this.myLoadingIcon.setVisible(false);
        this.myArchetypesPanel.setLayout((LayoutManager)((Object)new MyLayout()));
        this.myArchetypesPanel.add(this.myArchetypesScrollPane);
        this.myArchetypesPanel.add((Component)this.myLoadingIcon);
        this.mySelectAggregator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.myAggregator = MavenModuleWizardStep.this.doSelectProject(MavenModuleWizardStep.this.myAggregator);
                MavenModuleWizardStep.this.updateComponents();
            }
        });
        this.mySelectParent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.myParent = MavenModuleWizardStep.this.doSelectProject(MavenModuleWizardStep.this.myParent);
                MavenModuleWizardStep.this.updateComponents();
            }
        });
        ActionListener updatingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.updateComponents();
            }
        };
        this.myInheritGroupIdCheckBox.addActionListener(updatingListener);
        this.myInheritVersionCheckBox.addActionListener(updatingListener);
        this.myUseArchetypeCheckBox.addActionListener(updatingListener);
        this.myArchetypesTree.getSelectionModel().setSelectionMode(0);
        this.myAddArchetypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenModuleWizardStep.this.doAddArchetype();
            }
        });
        this.myArchetypesTree.setRootVisible(false);
        this.myArchetypesTree.setShowsRootHandles(true);
        this.myArchetypesTree.setCellRenderer((TreeCellRenderer)((Object)new MyRenderer()));
        this.myArchetypesTree.getSelectionModel().setSelectionMode(1);
        this.myArchetypesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MavenModuleWizardStep.this.updateArchetypeDescription();
            }
        });
        new TreeSpeedSearch(this.myArchetypesTree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                ArchetypeInfo info = MavenModuleWizardStep.this.getArchetypeInfoFromPathComponent(path.getLastPathComponent());
                return info.groupId + ":" + info.artifactId + ":" + info.version;
            }
        }).setComparator(new SpeedSearchBase.SpeedSearchComparator(false){

            public void translateCharacter(StringBuilder buf, char ch) {
                if (ch == '*') {
                    buf.append("(.)*");
                } else {
                    super.translateCharacter(buf, ch);
                }
            }
        });
        this.myArchetypeDescriptionField.setEditable(false);
        this.myArchetypeDescriptionField.setBackground(UIUtil.getPanelBackground());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    private MavenProject doSelectProject(MavenProject current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectMavenProjectDialog d = new SelectMavenProjectDialog(this.myProjectOrNull, current);
        d.show();
        if (!d.isOK()) {
            return current;
        }
        return d.getResult();
    }

    private void doAddArchetype() {
        MavenAddArchetypeDialog dialog = new MavenAddArchetypeDialog(this.myMainPanel);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        ArchetypeInfo archetype = dialog.getArchetype();
        MavenIndicesManager.getInstance().addArchetype(archetype);
        this.updateArchetypesList(archetype);
    }

    public void onStepLeaving() {
        this.myLoadingCancelled.set(true);
        this.saveSettings();
    }

    public void disposeUIResources() {
        this.myLoadingIcon.dispose();
        super.disposeUIResources();
    }

    private void loadSettings() {
        this.myBuilder.setInheritedOptions(this.getSavedValue(INHERIT_GROUP_ID_KEY, true), this.getSavedValue(INHERIT_VERSION_KEY, true));
        String archGroupId = this.getSavedValue(ARCHETYPE_GROUP_ID_KEY, null);
        String archArtifactId = this.getSavedValue(ARCHETYPE_ARTIFACT_ID_KEY, null);
        String archVersion = this.getSavedValue(ARCHETYPE_VERSION_KEY, null);
        if (archGroupId == null || archArtifactId == null || archVersion == null) {
            this.myBuilder.setArchetype(null);
        } else {
            this.myBuilder.setArchetype(new ArchetypeInfo(archGroupId, archArtifactId, archVersion, null, null));
        }
    }

    private void saveSettings() {
        this.saveValue(INHERIT_GROUP_ID_KEY, this.myInheritGroupIdCheckBox.isSelected());
        this.saveValue(INHERIT_VERSION_KEY, this.myInheritVersionCheckBox.isSelected());
        ArchetypeInfo arch = this.getSelectedArchetype();
        this.saveValue(ARCHETYPE_GROUP_ID_KEY, arch == null ? null : arch.groupId);
        this.saveValue(ARCHETYPE_ARTIFACT_ID_KEY, arch == null ? null : arch.artifactId);
        this.saveValue(ARCHETYPE_VERSION_KEY, arch == null ? null : arch.version);
    }

    private boolean getSavedValue(String key, boolean defaultValue) {
        return this.getSavedValue(key, String.valueOf(defaultValue)).equals(String.valueOf(true));
    }

    private String getSavedValue(String key, String defaultValue) {
        String value = PropertiesComponent.getInstance().getValue(key);
        return value == null ? defaultValue : value;
    }

    private void saveValue(String key, boolean value) {
        this.saveValue(key, String.valueOf(value));
    }

    private void saveValue(String key, String value) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(key, value);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void updateStep() {
        if (this.isMavenizedProject()) {
            MavenProject parent;
            this.myAggregator = parent = this.myBuilder.findPotentialParentProject(this.myProjectOrNull);
            this.myParent = parent;
        }
        this.myArtifactIdField.setText(this.myBuilder.getName());
        this.myGroupIdField.setText(this.myParent == null ? this.myBuilder.getName() : this.myParent.getMavenId().getGroupId());
        this.myVersionField.setText(this.myParent == null ? "1.0" : this.myParent.getMavenId().getVersion());
        this.myInheritGroupIdCheckBox.setSelected(this.myBuilder.isInheritGroupId());
        this.myInheritVersionCheckBox.setSelected(this.myBuilder.isInheritVersion());
        ArchetypeInfo selectedArch = this.getSelectedArchetype();
        if (selectedArch == null) {
            selectedArch = this.myBuilder.getArchetype();
        }
        if (selectedArch != null) {
            this.myUseArchetypeCheckBox.setSelected(true);
        }
        if (this.myArchetypesTree.getRowCount() == 0) {
            this.updateArchetypesList(selectedArch);
        }
        this.updateComponents();
    }

    private void updateArchetypesList(final ArchetypeInfo selected) {
        this.myLoadingCancelled.set(true);
        final AtomicBoolean currentStatus = this.myLoadingCancelled = new AtomicBoolean();
        this.myLoadingIcon.setVisible(true);
        this.myLoadingIcon.setBackground(this.myArchetypesTree.getBackground());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                final Set<ArchetypeInfo> archetypes = MavenIndicesManager.getInstance().getArchetypes();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreePath path;
                        if (currentStatus.get()) {
                            return;
                        }
                        MavenModuleWizardStep.this.myLoadingIcon.setVisible(false);
                        TreeNode root = MavenModuleWizardStep.this.groupAndSortArchetypes(archetypes);
                        DefaultTreeModel model = new DefaultTreeModel(root);
                        MavenModuleWizardStep.this.myArchetypesTree.setModel((TreeModel)model);
                        if (selected != null && (path = MavenModuleWizardStep.this.findNodePath(selected, model, model.getRoot())) != null) {
                            MavenModuleWizardStep.this.myArchetypesTree.expandPath(path.getParentPath());
                            TreeUtil.selectPath((JTree)MavenModuleWizardStep.this.myArchetypesTree, (TreePath)path, (boolean)true);
                        }
                        MavenModuleWizardStep.this.updateArchetypeDescription();
                    }
                });
            }
        });
    }

    private void updateArchetypeDescription() {
        String desc;
        ArchetypeInfo sel = this.getSelectedArchetype();
        String string = desc = sel == null ? null : sel.description;
        if (StringUtil.isEmptyOrSpaces((String)desc)) {
            this.myArchetypeDescriptionScrollPane.setVisible(false);
        } else {
            this.myArchetypeDescriptionScrollPane.setVisible(true);
            this.myArchetypeDescriptionField.setText(desc);
        }
        this.myMainPanel.revalidate();
    }

    private TreePath findNodePath(ArchetypeInfo object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode each = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (each.getUserObject().equals(object)) {
                return new TreePath(each.getPath());
            }
            TreePath result = this.findNodePath(object, model, each);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private TreeNode groupAndSortArchetypes(Set<ArchetypeInfo> archetypes) {
        ArrayList<ArchetypeInfo> list = new ArrayList<ArchetypeInfo>(archetypes);
        Collections.sort(list, new Comparator<ArchetypeInfo>(){

            @Override
            public int compare(ArchetypeInfo o1, ArchetypeInfo o2) {
                String key2;
                String key1 = o1.groupId + ":" + o1.artifactId;
                int result = key1.compareToIgnoreCase(key2 = o2.groupId + ":" + o2.artifactId);
                if (result != 0) {
                    return result;
                }
                return o2.version.compareToIgnoreCase(o1.version);
            }
        });
        TreeMap<String, ArrayList<ArchetypeInfo>> map = new TreeMap<String, ArrayList<ArchetypeInfo>>();
        for (ArchetypeInfo each : list) {
            String key = each.groupId + ":" + each.artifactId;
            ArrayList<ArchetypeInfo> versions = (ArrayList<ArchetypeInfo>)map.get(key);
            if (versions == null) {
                versions = new ArrayList<ArchetypeInfo>();
                map.put(key, versions);
            }
            versions.add(each);
        }
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("root", true);
        for (List each : map.values()) {
            ArchetypeInfo eachArchetype = (ArchetypeInfo)each.get(0);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(eachArchetype, true);
            for (ArchetypeInfo eachVersion : each) {
                DefaultMutableTreeNode versionNode = new DefaultMutableTreeNode(eachVersion, false);
                node.add(versionNode);
            }
            result.add(node);
        }
        return result;
    }

    private boolean isMavenizedProject() {
        return this.myProjectOrNull != null && MavenProjectsManager.getInstance(this.myProjectOrNull).isMavenizedProject();
    }

    private void updateComponents() {
        if (!this.isMavenizedProject()) {
            this.myAggregatorLabel.setEnabled(false);
            this.myAggregatorNameLabel.setEnabled(false);
            this.mySelectAggregator.setEnabled(false);
            this.myParentLabel.setEnabled(false);
            this.myParentNameLabel.setEnabled(false);
            this.mySelectParent.setEnabled(false);
        }
        this.myAggregatorNameLabel.setText(this.formatProjectString(this.myAggregator));
        this.myParentNameLabel.setText(this.formatProjectString(this.myParent));
        if (this.myParent == null) {
            this.myGroupIdField.setEnabled(true);
            this.myVersionField.setEnabled(true);
            this.myInheritGroupIdCheckBox.setEnabled(false);
            this.myInheritVersionCheckBox.setEnabled(false);
        } else {
            this.myGroupIdField.setEnabled(!this.myInheritGroupIdCheckBox.isSelected());
            this.myVersionField.setEnabled(!this.myInheritVersionCheckBox.isSelected());
            if (this.myInheritGroupIdCheckBox.isSelected() || this.myGroupIdField.getText().equals(this.myInheritedGroupId)) {
                this.myGroupIdField.setText(this.myParent.getMavenId().getGroupId());
            }
            if (this.myInheritVersionCheckBox.isSelected() || this.myVersionField.getText().equals(this.myInheritedVersion)) {
                this.myVersionField.setText(this.myParent.getMavenId().getVersion());
            }
            this.myInheritedGroupId = this.myGroupIdField.getText();
            this.myInheritedVersion = this.myVersionField.getText();
            this.myInheritGroupIdCheckBox.setEnabled(true);
            this.myInheritVersionCheckBox.setEnabled(true);
        }
        boolean archetypesEnabled = this.myUseArchetypeCheckBox.isSelected();
        this.myAddArchetypeButton.setEnabled(archetypesEnabled);
        this.myArchetypesTree.setEnabled(archetypesEnabled);
        this.myArchetypesTree.setBackground(archetypesEnabled ? UIUtil.getListBackground() : UIUtil.getPanelBackground());
    }

    private String formatProjectString(MavenProject project) {
        if (project == null) {
            return "<none>";
        }
        return project.getMavenId().getDisplayString();
    }

    public void updateDataModel() {
        this.myBuilder.setAggregatorProject(this.myAggregator);
        this.myBuilder.setParentProject(this.myParent);
        this.myBuilder.setProjectId(new MavenId(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText()));
        this.myBuilder.setInheritedOptions(this.myInheritGroupIdCheckBox.isSelected(), this.myInheritVersionCheckBox.isSelected());
        this.myBuilder.setArchetype(this.getSelectedArchetype());
    }

    private ArchetypeInfo getSelectedArchetype() {
        if (!this.myUseArchetypeCheckBox.isSelected() || this.myArchetypesTree.isSelectionEmpty()) {
            return null;
        }
        return this.getArchetypeInfoFromPathComponent(this.myArchetypesTree.getLastSelectedPathComponent());
    }

    private ArchetypeInfo getArchetypeInfoFromPathComponent(Object sel) {
        return (ArchetypeInfo)((DefaultMutableTreeNode)sel).getUserObject();
    }

    public Icon getIcon() {
        return WIZARD_ICON;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.maven";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextArea jTextArea;
        JScrollPane jScrollPane;
        JButton jButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JLabel jLabel2;
        JButton jButton2;
        JLabel jLabel3;
        JButton jButton3;
        JLabel jLabel4;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(8, 8, 8, 8), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("GroupId");
        jPanel2.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("ArtifactId");
        jPanel2.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Version");
        jPanel2.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupIdField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myArtifactIdField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVersionField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAggregatorLabel = jLabel4 = new JLabel();
        jLabel4.setText("Add as module to");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySelectAggregator = jButton3 = new JButton();
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.setText("...");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentLabel = jLabel3 = new JLabel();
        jLabel3.setText("Parent");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySelectParent = jButton2 = new JButton();
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setText("...");
        jPanel2.add((Component)jButton2, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAggregatorNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myParentNameLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 4, 0, null, null, null));
        this.myInheritGroupIdCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Inherit");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInheritVersionCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Inherit");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUseArchetypeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create from archetype");
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myAddArchetypeButton = jButton = new JButton();
        jButton.setText("Add archetype...");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myArchetypeDescriptionScrollPane = jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(7, 0, 1, 3, 0, 3, 7, 0, null, null, null));
        this.myArchetypeDescriptionField = jTextArea = new JTextArea();
        jTextArea.setRows(3);
        ((Component)jTextArea).setBackground(UIManager.getColor("Panel.background"));
        jScrollPane.setViewportView(jTextArea);
        this.myArchetypesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return MavenModuleWizardStep.this.myArchetypesScrollPane.getPreferredSize();
        }

        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            MavenModuleWizardStep.this.myArchetypesScrollPane.setBounds(new Rectangle(0, 0, w, h));
            Dimension is = MavenModuleWizardStep.this.myLoadingIcon.getPreferredSize();
            MavenModuleWizardStep.this.myLoadingIcon.setBounds(new Rectangle((w - is.width) / 2, (h - is.height) / 2, is.width, is.height));
        }
    }

    private class MyRenderer
    extends ColoredTreeCellRenderer {
        private MyRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (!(userObject instanceof ArchetypeInfo)) {
                return;
            }
            ArchetypeInfo info = (ArchetypeInfo)userObject;
            if (leaf) {
                this.append(info.artifactId, SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.append(":" + info.version, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.append(info.groupId + ":", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.append(info.artifactId, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

