/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerConfigurable;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.MavenIndicesConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenImportingConfigurable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenSettings
implements SearchableConfigurable.Parent {
    private final Project myProject;
    private final Configurable myConfigurable;
    private final List<Configurable> myChildren;

    public MavenSettings(Project project) {
        this.myProject = project;
        this.myConfigurable = new MavenGeneralConfigurable(){

            @Override
            protected MavenGeneralSettings getState() {
                return MavenProjectsManager.getInstance(MavenSettings.this.myProject).getGeneralSettings();
            }
        };
        this.myChildren = new ArrayList<Configurable>();
        this.myChildren.add((Configurable)new MavenImportingConfigurable(MavenProjectsManager.getInstance(this.myProject).getImportingSettings()));
        this.myChildren.add((Configurable)new MavenIgnoredFilesConfigurable(MavenProjectsManager.getInstance(this.myProject)));
        this.myChildren.add((Configurable)new MavenRunnerConfigurable(this.myProject, false){

            @Override
            protected MavenRunnerSettings getState() {
                return MavenRunner.getInstance(MavenSettings.this.myProject).getState();
            }
        });
        if (!this.myProject.isDefault()) {
            this.myChildren.add((Configurable)new MavenIndicesConfigurable(this.myProject));
        }
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myConfigurable.createComponent();
    }

    public boolean isModified() {
        return this.myConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    public Configurable[] getConfigurables() {
        return this.myChildren.toArray(new Configurable[this.myChildren.size()]);
    }

    public String getId() {
        return MavenSettings.class.getSimpleName();
    }

    @Nls
    public String getDisplayName() {
        return "Maven";
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableEditor.png");
    }

    public String getHelpTopic() {
        return this.myConfigurable.getHelpTopic();
    }
}

