/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.utils.actions.MavenToggleAction;

public abstract class ToggleCompilerTasksAction
extends MavenToggleAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && !this.getTasks(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        return this.hasTask(this.getTasksManager(e), this.getTasks(e).get(0));
    }

    public void setSelected(AnActionEvent e, boolean state) {
        List<MavenCompilerTask> tasks = this.getTasks(e);
        if (state) {
            this.addTasks(this.getTasksManager(e), tasks);
        } else {
            this.removeTasks(this.getTasksManager(e), tasks);
        }
    }

    protected List<MavenCompilerTask> getTasks(AnActionEvent e) {
        MavenProject project = MavenActionUtil.getMavenProject(e);
        if (project == null) {
            return Collections.EMPTY_LIST;
        }
        List goals = (List)e.getData(MavenDataKeys.MAVEN_GOALS);
        if (goals == null || goals.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MavenCompilerTask> result = new ArrayList<MavenCompilerTask>();
        for (String each : goals) {
            result.add(new MavenCompilerTask(project.getPath(), each));
        }
        return result;
    }

    protected abstract boolean hasTask(MavenTasksManager var1, MavenCompilerTask var2);

    protected abstract void addTasks(MavenTasksManager var1, List<MavenCompilerTask> var2);

    protected abstract void removeTasks(MavenTasksManager var1, List<MavenCompilerTask> var2);

    private MavenTasksManager getTasksManager(AnActionEvent e) {
        return MavenTasksManager.getInstance(MavenActionUtil.getProject(e));
    }
}

