/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.execution.impl.BaseExecuteBeforeRunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.TasksBundle;

public class MavenExecuteBeforeRunDialog
extends BaseExecuteBeforeRunDialog<MavenBeforeRunTask> {
    private final MavenProject myMavenProject;
    private final String myGoal;

    public MavenExecuteBeforeRunDialog(Project project, MavenProject mavenProject, String goal) {
        super(project);
        this.myMavenProject = mavenProject;
        this.myGoal = goal;
        this.init();
    }

    protected String getTargetDisplayString() {
        return TasksBundle.message("maven.tasks.goal", new Object[0]);
    }

    protected Key<MavenBeforeRunTask> getTaskID() {
        return MavenBeforeRunTasksProvider.TASK_ID;
    }

    protected boolean isRunning(MavenBeforeRunTask task) {
        return task.isFor(this.myMavenProject, this.myGoal);
    }

    protected void update(MavenBeforeRunTask task) {
        task.setProjectPath(this.myMavenProject.getPath());
        task.setGoal(this.myGoal);
    }

    protected void clear(MavenBeforeRunTask task) {
        task.setProjectPath(null);
        task.setGoal(null);
    }
}

