/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.configurations.JavaClasspathPolicyExtender;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectClasspathTraversing;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.roots.RootPolicy;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenJavaClasspathPolicyExtender
implements JavaClasspathPolicyExtender {
    @NotNull
    public ProjectRootsTraversing.RootTraversePolicy extend(Project project, @NotNull ProjectRootsTraversing.RootTraversePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenJavaClasspathPolicyExtender.extend must not be null");
        }
        ProjectRootsTraversing.RootTraversePolicy rootTraversePolicy = policy;
        if (rootTraversePolicy == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenJavaClasspathPolicyExtender.extend must not return null");
        }
        return rootTraversePolicy;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ProjectRootsTraversing.RootTraversePolicy extend(Module module, @NotNull ProjectRootsTraversing.RootTraversePolicy policy) {
        ProjectRootsTraversing.RootTraversePolicy rootTraversePolicy;
        if (policy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/execution/MavenJavaClasspathPolicyExtender.extend must not be null");
        }
        Project project = module.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject() || !manager.isMavenizedModule(module)) {
            rootTraversePolicy = policy;
            if (rootTraversePolicy == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenJavaClasspathPolicyExtender.extend must not return null");
            return rootTraversePolicy;
        }
        rootTraversePolicy = new ProjectRootsTraversing.RootTraversePolicy(this.extend(module, manager, policy.getVisitSource(), false), policy.getVisitJdk(), this.extend(module, manager, policy.getVisitLibrary(), true), this.extend(module, manager, policy.getVisitModule(), true));
        if (rootTraversePolicy != null) return rootTraversePolicy;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/execution/MavenJavaClasspathPolicyExtender.extend must not return null");
    }

    private <T extends OrderEntry> ProjectRootsTraversing.RootTraversePolicy.Visit<T> extend(final Module originalModule, final MavenProjectsManager manager, final ProjectRootsTraversing.RootTraversePolicy.Visit<T> original, final boolean skipDependencyModules) {
        return new ProjectRootsTraversing.RootTraversePolicy.Visit<T>(){

            public void visit(T entry, ProjectRootsTraversing.TraverseState state, RootPolicy<ProjectRootsTraversing.TraverseState> policy) {
                Module ownerModule = entry.getOwnerModule();
                if (skipDependencyModules && originalModule != ownerModule) {
                    return;
                }
                if (originalModule != ownerModule && entry instanceof ModuleSourceOrderEntry) {
                    MavenProject project = manager.findProject(originalModule);
                    MavenProject depProject = manager.findProject(ownerModule);
                    if (project == null || depProject == null) {
                        original.visit(entry, state, policy);
                        return;
                    }
                    for (MavenArtifact each : project.findDependencies(depProject)) {
                        boolean isTestClasspath;
                        boolean bl = isTestClasspath = original == ProjectClasspathTraversing.ALL_OUTPUTS;
                        if (!isTestClasspath && "provided".equals(each.getScope()) || !isTestClasspath && "test".equals(each.getScope())) continue;
                        boolean isTestJar = "test-jar".equals(each.getType()) || "tests".equals(each.getClassifier());
                        MavenJavaClasspathPolicyExtender.this.addOutput(ownerModule, isTestJar, state);
                    }
                } else {
                    if (entry instanceof ExportableOrderEntry) {
                        boolean isTestClasspath;
                        boolean bl = isTestClasspath = original == ProjectRootsTraversing.RootTraversePolicy.ADD_CLASSES || original == ProjectRootsTraversing.RootTraversePolicy.RECURSIVE;
                        if (!isTestClasspath && ((ExportableOrderEntry)entry).getScope() == DependencyScope.PROVIDED) {
                            return;
                        }
                    }
                    original.visit(entry, state, policy);
                }
            }
        };
    }

    public void addOutput(Module module, boolean tests, ProjectRootsTraversing.TraverseState state) {
        String output;
        CompilerModuleExtension ex = CompilerModuleExtension.getInstance((Module)module);
        if (ex == null) {
            return;
        }
        String string = output = tests ? ex.getCompilerOutputUrlForTests() : ex.getCompilerOutputUrl();
        if (output != null) {
            state.addAllUrls(Collections.singletonList(output));
        }
    }
}

