/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.embedder;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.jetbrains.idea.maven.embedder.MavenExecutionOptions;

public abstract class MavenConsole {
    public static final int LEVEL_AUTO = -1;
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int LEVEL_DISABLED = 5;
    public static final int LEVEL_ALWAYS = 6;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final int myOutputLevel;
    private final boolean myPrintStrackTrace;
    private boolean isFinished;
    private static final Map<String, Integer> PREFIX_TO_LEVEL = new THashMap();
    private static final Map<Integer, String> LEVEL_TO_PREFIX = new THashMap();

    private static void map(String prefix, int level) {
        PREFIX_TO_LEVEL.put(prefix, level);
        LEVEL_TO_PREFIX.put(level, prefix);
    }

    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean printStrackTrace) {
        this.myOutputLevel = outputLevel.getLevel();
        this.myPrintStrackTrace = printStrackTrace;
    }

    public boolean isSuppressed(int level) {
        return level < this.myOutputLevel;
    }

    public boolean isSuppressed(String line) {
        return this.isSuppressed(MavenConsole.getLevel(line));
    }

    public abstract boolean canPause();

    public abstract boolean isOutputPaused();

    public abstract void setOutputPaused(boolean var1);

    public boolean isFinished() {
        return this.isFinished;
    }

    public void finish() {
        this.isFinished = true;
    }

    public abstract void attachToProcess(ProcessHandler var1);

    public void systemMessage(int level, String string, Throwable throwable) {
        this.printMessage(level, string, throwable);
    }

    public void printMessage(int level, String string, Throwable throwable) {
        if (this.isSuppressed(level)) {
            return;
        }
        OutputType type = OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type = OutputType.ERROR;
        }
        this.doPrint(MavenConsole.composeLine(level, string), type);
        if (level == 4) {
            this.setOutputPaused(false);
        }
        if (throwable != null) {
            String message = null;
            for (Throwable temp = throwable; temp != null; temp = temp.getCause()) {
                if (!(temp instanceof AbstractMojoExecutionException)) continue;
                message = this.appendExecutionFailureMessage(message, temp.getMessage());
                message = this.appendExecutionFailureMessage(message, ((AbstractMojoExecutionException)temp).getLongMessage());
                if (temp.getCause() == null) break;
                message = this.appendExecutionFailureMessage(message, temp.getCause().getMessage());
                break;
            }
            if (message == null) {
                message = throwable.getMessage();
            }
            if (message != null) {
                message = message + LINE_SEPARATOR;
                this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, message), type);
            }
            if (this.myPrintStrackTrace) {
                this.doPrint(LINE_SEPARATOR + StringUtil.getThrowableText((Throwable)throwable), OutputType.ERROR);
            } else {
                this.doPrint(LINE_SEPARATOR + "To view full stack traces, please go to the Settings->Maven and check the 'Print Exception Stack Traces' box." + LINE_SEPARATOR, type);
            }
        }
    }

    private String appendExecutionFailureMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + LINE_SEPARATOR + LINE_SEPARATOR + newMessage;
    }

    protected abstract void doPrint(String var1, OutputType var2);

    private static int getLevel(String line) {
        return MavenConsole.getLevelByPrefix(MavenConsole.extractPrefix(line));
    }

    private static String extractPrefix(String line) {
        int closing;
        if (line.startsWith("[") && (closing = line.indexOf("] ", 1)) > 1) {
            return line.substring(1, closing);
        }
        return "";
    }

    private static int getLevelByPrefix(String prefix) {
        Integer level = PREFIX_TO_LEVEL.get(prefix);
        return level != null ? level : 6;
    }

    private static String composeLine(int level, String message) {
        return MessageFormat.format("[{0}] {1}", MavenConsole.getPrefixByLevel(level), message);
    }

    private static String getPrefixByLevel(int level) {
        return LEVEL_TO_PREFIX.get(level);
    }

    static {
        MavenConsole.map("DEBUG", 0);
        MavenConsole.map("INFO", 1);
        MavenConsole.map("WARNING", 2);
        MavenConsole.map("ERROR", 3);
        MavenConsole.map("FATAL_ERROR", 4);
    }

    public static enum OutputType {
        NORMAL,
        SYSTEM,
        ERROR;

    }
}

